/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site.parser.processors;

import java.nio.file.FileSystems;
import org.apache.maven.doxia.sink.Sink;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.site.parser.NodeProcessor;
import org.asciidoctor.maven.site.parser.NodeSinker;
import org.asciidoctor.maven.site.parser.processors.AbstractSinkNodeProcessor;
import org.asciidoctor.maven.site.parser.processors.SinkAttributes;
import org.asciidoctor.maven.site.parser.processors.Styles;
import org.asciidoctor.maven.site.parser.processors.TitleCaptionExtractor;

public class ImageNodeProcessor
extends AbstractSinkNodeProcessor
implements NodeProcessor {
    public ImageNodeProcessor(Sink sink, NodeSinker nodeSinker) {
        super(sink, nodeSinker);
    }

    @Override
    public boolean applies(StructuralNode node) {
        return "image".equals(node.getNodeName());
    }

    @Override
    public void process(StructuralNode node) {
        String target = (String)node.getAttribute((Object)"target");
        String alt = (String)node.getAttribute((Object)"alt");
        String imagesdir = (String)node.getAttribute((Object)"imagesdir");
        String imagePath = StringUtils.isBlank((CharSequence)imagesdir) ? target : this.formatPath(imagesdir, target);
        Sink sink = this.getSink();
        sink.division();
        sink.figureGraphics(imagePath, !StringUtils.isBlank((CharSequence)alt) ? SinkAttributes.of("alt", alt) : null);
        String title = TitleCaptionExtractor.getText(node);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            sink.division(SinkAttributes.of("style", Styles.CAPTION));
            sink.rawText(title);
            sink.division_();
        }
        sink.division_();
    }

    private String formatPath(String imagesdir, String target) {
        if (imagesdir.endsWith("/") || imagesdir.endsWith("\\")) {
            return imagesdir + target;
        }
        return imagesdir + FileSystems.getDefault().getSeparator() + target;
    }
}

