/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site.parser.processors;

import java.util.List;
import org.apache.maven.doxia.sink.Sink;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.site.parser.NodeProcessor;
import org.asciidoctor.maven.site.parser.NodeSinker;
import org.asciidoctor.maven.site.parser.processors.AbstractSinkNodeProcessor;
import org.asciidoctor.maven.site.parser.processors.SinkAttributes;
import org.asciidoctor.maven.site.parser.processors.Styles;
import org.asciidoctor.maven.site.parser.processors.TitleCaptionExtractor;

public class ExampleNodeProcessor
extends AbstractSinkNodeProcessor
implements NodeProcessor {
    public ExampleNodeProcessor(Sink sink, NodeSinker nodeSinker) {
        super(sink, nodeSinker);
    }

    @Override
    public boolean applies(StructuralNode node) {
        return "example".equals(node.getNodeName());
    }

    @Override
    public void process(StructuralNode node) {
        List blocks;
        Sink sink = this.getSink();
        sink.division();
        String title = TitleCaptionExtractor.getText(node);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            sink.division(SinkAttributes.of("style", Styles.CAPTION));
            sink.rawText(title);
            sink.division_();
        }
        if (!(blocks = node.getBlocks()).isEmpty()) {
            this.divWrap(sink, () -> blocks.forEach(this::sink));
        } else {
            String content = (String)node.getContent();
            if (StringUtils.isNotBlank((CharSequence)content)) {
                this.divWrap(sink, () -> sink.rawText(content));
            }
        }
        sink.division_();
    }

    void divWrap(Sink sink, Runnable consumer) {
        sink.division(SinkAttributes.of("style", Styles.EXAMPLE));
        consumer.run();
        sink.division_();
    }
}

