/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven;

import java.io.File;
import java.util.Properties;
import javax.inject.Singleton;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.maven.AsciidoctorMojo;
import org.asciidoctor.maven.commons.AsciidoctorHelper;
import org.asciidoctor.maven.commons.StringUtils;

@Singleton
public class AsciidoctorOptionsFactory {
    private Attributes createAttributes(AsciidoctorMojo configuration, MavenProject mavenProject, Log log) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        if (configuration.isEmbedAssets()) {
            attributesBuilder.linkCss(false);
            attributesBuilder.dataUri(true);
        }
        AsciidoctorHelper.addProperties((Properties)mavenProject.getProperties(), (AttributesBuilder)attributesBuilder);
        AsciidoctorHelper.addAttributes(configuration.getAttributes(), (AttributesBuilder)attributesBuilder);
        if (StringUtils.isNotBlank((CharSequence)configuration.getAttributesChain())) {
            log.info((CharSequence)("Attributes: " + configuration.getAttributesChain()));
            attributesBuilder.arguments(configuration.getAttributesChain());
        }
        return attributesBuilder.build();
    }

    OptionsBuilder create(AsciidoctorMojo configuration, MavenProject mavenProject, Log log) {
        OptionsBuilder optionsBuilder = Options.builder().backend(configuration.getBackend()).safe(SafeMode.UNSAFE).standalone(configuration.standalone).mkDirs(true);
        if (!StringUtils.isBlank((CharSequence)configuration.getEruby())) {
            optionsBuilder.eruby(configuration.getEruby());
        }
        if (configuration.isSourcemap()) {
            optionsBuilder.option("sourcemap", (Object)true);
        }
        if (configuration.isCatalogAssets()) {
            optionsBuilder.option("catalog_assets", (Object)true);
        }
        if (!configuration.isTemplateCache()) {
            optionsBuilder.option("template_cache", (Object)false);
        }
        if (configuration.getDoctype() != null) {
            optionsBuilder.docType(configuration.getDoctype());
        }
        if (configuration.getTemplateEngine() != null) {
            optionsBuilder.templateEngine(configuration.getTemplateEngine());
        }
        if (!configuration.getTemplateDirs().isEmpty()) {
            optionsBuilder.templateDirs(configuration.getTemplateDirs().toArray(new File[0]));
        }
        Attributes attributes = this.createAttributes(configuration, mavenProject, log);
        return optionsBuilder.attributes(attributes);
    }
}

