/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.maven.doxia.module.xhtml.XhtmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.maven.AsciidoctorHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=Parser.class, hint="asciidoc")
public class AsciidoctorDoxiaParser
extends XhtmlParser {
    @Inject
    protected Provider<MavenProject> mavenProjectProvider;
    public static final String ROLE_HINT = "asciidoc";
    protected final Asciidoctor asciidoctor = Asciidoctor.Factory.create();

    public void parse(Reader reader, Sink sink) throws ParseException {
        String source = null;
        try {
            source = IOUtil.toString((Reader)reader);
            if (source == null) {
                source = "";
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("Could not read AsciiDoc source: " + ex.getLocalizedMessage()));
            return;
        }
        MavenProject project = (MavenProject)this.mavenProjectProvider.get();
        Xpp3Dom siteConfig = this.getSiteConfig(project);
        File siteDirectory = this.resolveSiteDirectory(project, siteConfig);
        OptionsBuilder options = this.processAsciiDocConfig(project, siteConfig, this.initOptions(project, siteDirectory), this.initAttributes(project, siteDirectory));
        sink.rawText(this.convertAsciiDoc(source, options));
    }

    protected Xpp3Dom getSiteConfig(MavenProject project) {
        return project.getGoalConfiguration("org.apache.maven.plugins", "maven-site-plugin", "site", "site");
    }

    protected File resolveSiteDirectory(MavenProject project, Xpp3Dom siteConfig) {
        Xpp3Dom siteDirectoryNode;
        File siteDirectory = new File(project.getBasedir(), "src/site");
        if (siteConfig != null && (siteDirectoryNode = siteConfig.getChild("siteDirectory")) != null) {
            siteDirectory = new File(siteDirectoryNode.getValue());
        }
        return siteDirectory;
    }

    protected OptionsBuilder initOptions(MavenProject project, File siteDirectory) {
        return OptionsBuilder.options().backend("xhtml").safe(SafeMode.UNSAFE).baseDir(new File(siteDirectory, ROLE_HINT));
    }

    protected AttributesBuilder initAttributes(MavenProject project, File siteDirectory) {
        return AttributesBuilder.attributes().attribute("idprefix", (Object)"@").attribute("showtitle", (Object)"@");
    }

    protected OptionsBuilder processAsciiDocConfig(MavenProject project, Xpp3Dom siteConfig, OptionsBuilder options, AttributesBuilder attributes) {
        if (siteConfig == null) {
            return options.attributes(attributes);
        }
        Xpp3Dom asciidocConfig = siteConfig.getChild(ROLE_HINT);
        if (asciidocConfig == null) {
            return options.attributes(attributes);
        }
        if (project.getProperties() != null) {
            for (Map.Entry entry : project.getProperties().entrySet()) {
                attributes.attribute(((String)entry.getKey()).replaceAll("\\.", "-"), entry.getValue());
            }
        }
        for (Xpp3Dom asciidocOpt : asciidocConfig.getChildren()) {
            String optName = asciidocOpt.getName();
            if ("attributes".equals(optName)) {
                for (Xpp3Dom asciidocAttr : asciidocOpt.getChildren()) {
                    AsciidoctorHelper.addAttribute(asciidocAttr.getName(), asciidocAttr.getValue(), attributes);
                }
                continue;
            }
            if ("requires".equals(optName)) {
                Xpp3Dom[] requires = asciidocOpt.getChildren("require");
                if (requires.length > 0) {
                    for (Xpp3Dom xpp3Dom : requires) {
                        this.requireLibrary(xpp3Dom.getValue());
                    }
                    continue;
                }
                for (String string : asciidocOpt.getValue().split(",")) {
                    this.requireLibrary(string);
                }
                continue;
            }
            if ("templateDir".equals(optName) || "template_dir".equals(optName)) {
                options.templateDir(this.resolveProjectDir(project, asciidocOpt.getValue()));
                continue;
            }
            if ("templateDirs".equals(optName) || "template_dirs".equals(optName)) {
                ArrayList<File> templateDirs = new ArrayList<File>();
                for (Xpp3Dom xpp3Dom : asciidocOpt.getChildren("dir")) {
                    templateDirs.add(this.resolveProjectDir(project, xpp3Dom.getValue()));
                }
                if (templateDirs.isEmpty()) continue;
                options.templateDirs(templateDirs.toArray(new File[templateDirs.size()]));
                continue;
            }
            if ("baseDir".equals(optName)) {
                options.baseDir(this.resolveProjectDir(project, asciidocOpt.getValue()));
                continue;
            }
            options.option(optName.replaceAll("(?<!_)([A-Z])", "_$1").toLowerCase(), (Object)asciidocOpt.getValue());
        }
        return options.attributes(attributes);
    }

    protected String convertAsciiDoc(String source, OptionsBuilder options) {
        return this.asciidoctor.convert(source, options);
    }

    protected File resolveProjectDir(MavenProject project, String path) {
        File filePath = new File(path);
        if (!filePath.isAbsolute()) {
            filePath = new File(project.getBasedir(), filePath.toString());
        }
        return filePath;
    }

    private void requireLibrary(String require) {
        if (!(require = require.trim()).isEmpty()) {
            try {
                this.asciidoctor.requireLibrary(new String[]{require});
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)ex.getLocalizedMessage());
            }
        }
    }
}

