/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoc.maven;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="process-asciidoc")
public class AsciidoctorMojo
extends AbstractMojo {
    @Parameter(property="sourceDir", defaultValue="${basedir}/src/main/asciidoc", required=true)
    protected File sourceDirectory;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/generated-docs", required=true)
    protected File outputDirectory;
    @Parameter(property="backend", defaultValue="docbook", required=true)
    protected String backend;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.ensureOutputExists();
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine rubyEngine = engineManager.getEngineByName("jruby");
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("srcDir", (Object)this.sourceDirectory.getAbsolutePath());
        bindings.put("outputDir", (Object)this.outputDirectory.getAbsolutePath());
        bindings.put("backend", (Object)this.backend);
        try {
            InputStream script = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("execute_asciidoctor.rb");
            InputStreamReader streamReader = new InputStreamReader(script);
            rubyEngine.eval((Reader)streamReader, (Bindings)bindings);
        }
        catch (ScriptException e) {
            this.getLog().error((CharSequence)"Error running ruby script", (Throwable)e);
        }
    }

    private void ensureOutputExists() {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().error((CharSequence)("Can't create " + this.outputDirectory.getPath()));
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }
}

