/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileSplit {
    public static List<File> split(File f, File dir, int splitSize) throws IOException {
        int partCounter = 1;
        long sizeOfFiles = (long)splitSize * 0x100000L;
        byte[] buffer = new byte[(int)sizeOfFiles];
        ArrayList<File> files = new ArrayList<File>();
        String fileName = f.getName();
        try (FileInputStream fis = new FileInputStream(f);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            int bytesAmount = 0;
            while ((bytesAmount = bis.read(buffer)) > 0) {
                String filePartName = String.format("%s.%03d", fileName, partCounter++);
                File newFile = new File(dir, filePartName);
                try (FileOutputStream out = new FileOutputStream(newFile);){
                    out.write(buffer, 0, bytesAmount);
                }
                files.add(newFile);
            }
        }
        return files;
    }
}

