/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.logic.keep;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.arvados.client.exception.ArvadosClientException;

public class KeepLocator {
    private final List<String> hints = new ArrayList<String>();
    private String permSig;
    private LocalDateTime permExpiry;
    private final String md5sum;
    private final Integer size;

    public KeepLocator(String locatorString) {
        LinkedList<String> pieces = new LinkedList<String>(Arrays.asList(locatorString.split("\\+")));
        this.md5sum = pieces.poll();
        this.size = Integer.valueOf(Objects.requireNonNull(pieces.poll()));
        for (String hint : pieces) {
            if (!hint.matches("^[A-Z][A-Za-z0-9@_-]+$")) {
                throw new ArvadosClientException(String.format("invalid hint format: %s", hint));
            }
            if (hint.startsWith("A")) {
                this.parsePermissionHint(hint);
                continue;
            }
            this.hints.add(hint);
        }
    }

    public List<String> getHints() {
        return this.hints;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public String toString() {
        return Stream.concat(Stream.of(this.md5sum, this.size.toString(), this.permissionHint()), this.hints.stream()).filter(Objects::nonNull).collect(Collectors.joining("+"));
    }

    public String stripped() {
        return this.size != null ? String.format("%s+%d", this.md5sum, this.size) : this.md5sum;
    }

    public String permissionHint() {
        if (this.permSig == null || this.permExpiry == null) {
            return null;
        }
        long timestamp = this.permExpiry.toEpochSecond(ZoneOffset.UTC);
        String signTimestamp = Long.toHexString(timestamp);
        return String.format("A%s@%s", this.permSig, signTimestamp);
    }

    private void parsePermissionHint(String hint) {
        String[] hintSplit = hint.substring(1).split("@", 2);
        this.permSig = hintSplit[0];
        int permExpiryDecimal = Integer.parseInt(hintSplit[1], 16);
        this.permExpiry = LocalDateTime.ofInstant(Instant.ofEpochSecond(permExpiryDecimal), ZoneOffset.UTC);
    }
}

