/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.logic.keep;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.arvados.client.api.client.KeepServicesApiClient;
import org.arvados.client.api.model.Item;
import org.arvados.client.api.model.KeepService;
import org.arvados.client.api.model.KeepServiceList;
import org.arvados.client.config.ConfigProvider;
import org.arvados.client.exception.ArvadosApiException;
import org.arvados.client.exception.ArvadosClientException;
import org.arvados.client.logic.keep.FileTransferHandler;
import org.arvados.client.logic.keep.KeepLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepClient {
    private final KeepServicesApiClient keepServicesApiClient;
    private final Logger log = LoggerFactory.getLogger(KeepClient.class);
    private List<KeepService> keepServices;
    private List<KeepService> writableServices;
    private Map<String, KeepService> gatewayServices;
    private Integer maxReplicasPerService;
    private final ConfigProvider config;

    public KeepClient(ConfigProvider config) {
        this.config = config;
        this.keepServicesApiClient = new KeepServicesApiClient(config);
    }

    public byte[] getDataChunk(KeepLocator keepLocator) {
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, FileTransferHandler> rootsMap = new HashMap<String, FileTransferHandler>();
        List<String> sortedRoots = this.mapNewServices(rootsMap, keepLocator, false, false, headers);
        byte[] dataChunk = sortedRoots.stream().map(rootsMap::get).map(r -> r.get(keepLocator)).filter(Objects::nonNull).findFirst().orElse(null);
        if (dataChunk == null) {
            throw new ArvadosClientException("No server responding. Unable to download data chunk.");
        }
        return dataChunk;
    }

    public String put(File data, int copies, int numRetries) {
        byte[] fileBytes;
        try {
            fileBytes = FileUtils.readFileToByteArray((File)data);
        }
        catch (IOException e) {
            throw new ArvadosClientException("An error occurred while reading data chunk", e);
        }
        String dataHash = DigestUtils.md5Hex((byte[])fileBytes);
        String locatorString = String.format("%s+%d", dataHash, data.length());
        if (copies < 1) {
            return locatorString;
        }
        KeepLocator locator = new KeepLocator(locatorString);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Keep-Desired-Replicas", String.valueOf(copies));
        HashMap<String, FileTransferHandler> rootsMap = new HashMap<String, FileTransferHandler>();
        List<String> sortedRoots = this.mapNewServices(rootsMap, locator, false, true, headers);
        int numThreads = 0;
        numThreads = this.maxReplicasPerService == null || this.maxReplicasPerService >= copies ? 1 : Double.valueOf(Math.ceil(1.0 * (double)copies / (double)this.maxReplicasPerService.intValue())).intValue();
        this.log.debug("Pool max threads is {}", (Object)numThreads);
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < numThreads; ++i) {
            String root = sortedRoots.get(i);
            FileTransferHandler keepServiceLocal = (FileTransferHandler)rootsMap.get(root);
            futures.add(CompletableFuture.supplyAsync(() -> keepServiceLocal.put(dataHash, data)));
        }
        CompletableFuture[] array = futures.toArray(new CompletableFuture[0]);
        return Stream.of(array).map(CompletableFuture::join).reduce((a, b) -> b).orElse(null);
    }

    private List<String> mapNewServices(Map<String, FileTransferHandler> rootsMap, KeepLocator locator, boolean forceRebuild, boolean needWritable, Map<String, String> headers) {
        headers.putIfAbsent("Authorization", String.format("OAuth2 %s", this.config.getApiToken()));
        List<String> localRoots = this.weightedServiceRoots(locator, forceRebuild, needWritable);
        for (String root : localRoots) {
            FileTransferHandler keepServiceLocal = new FileTransferHandler(root, headers, this.config);
            rootsMap.putIfAbsent(root, keepServiceLocal);
        }
        return localRoots;
    }

    private List<String> weightedServiceRoots(KeepLocator locator, boolean forceRebuild, boolean needWritable) {
        this.buildServicesList(forceRebuild);
        ArrayList<String> sortedRoots = new ArrayList<String>();
        for (String hint : locator.getHints()) {
            KeepService svc;
            if (!hint.startsWith("K@")) continue;
            if (hint.length() == 7) {
                sortedRoots.add(String.format("https://keep.%s.arvadosapi.com/", hint.substring(2)));
                continue;
            }
            if (hint.length() != 29 || (svc = this.gatewayServices.get(hint.substring(2))) == null) continue;
            sortedRoots.add(svc.getServiceRoot());
        }
        List<KeepService> useServices = this.keepServices;
        if (needWritable) {
            useServices = this.writableServices;
        }
        this.anyNonDiskServices(useServices);
        sortedRoots.addAll(useServices.stream().sorted((ks1, ks2) -> KeepClient.serviceWeight(locator.getMd5sum(), ks2.getUuid()).compareTo(KeepClient.serviceWeight(locator.getMd5sum(), ks1.getUuid()))).map(KeepService::getServiceRoot).collect(Collectors.toList()));
        return sortedRoots;
    }

    private void buildServicesList(boolean forceRebuild) {
        KeepServiceList keepServiceList;
        if (this.keepServices != null && !forceRebuild) {
            return;
        }
        try {
            keepServiceList = this.keepServicesApiClient.accessible();
        }
        catch (ArvadosApiException e) {
            throw new ArvadosClientException("Cannot obtain list of accessible keep services");
        }
        this.gatewayServices = keepServiceList.getItems().stream().collect(Collectors.toMap(Item::getUuid, Function.identity()));
        if (this.gatewayServices.isEmpty()) {
            throw new ArvadosClientException("No gateway services available!");
        }
        for (KeepService keepService : this.gatewayServices.values()) {
            String serviceHost = keepService.getServiceHost();
            if (!serviceHost.startsWith("[") && serviceHost.contains(":")) {
                serviceHost = String.format("[%s]", serviceHost);
            }
            String protocol = keepService.getServiceSslFlag() != false ? "https" : "http";
            String serviceRoot = String.format("%s://%s:%d/", protocol, serviceHost, keepService.getServicePort());
            keepService.setServiceRoot(serviceRoot);
        }
        this.keepServices = this.gatewayServices.values().stream().filter(ks -> !ks.getServiceType().startsWith("gateway:")).collect(Collectors.toList());
        this.writableServices = this.keepServices.stream().filter(ks -> ks.getReadOnly() == false).collect(Collectors.toList());
        this.maxReplicasPerService = this.anyNonDiskServices(this.writableServices) != false ? null : Integer.valueOf(1);
    }

    private Boolean anyNonDiskServices(List<KeepService> useServices) {
        return useServices.stream().anyMatch(ks -> !ks.getServiceType().equals("disk"));
    }

    private static String serviceWeight(String dataHash, String serviceUuid) {
        String shortenedUuid;
        if (serviceUuid != null && serviceUuid.length() >= 15) {
            int substringIndex = serviceUuid.length() - 15;
            shortenedUuid = serviceUuid.substring(substringIndex);
        } else {
            shortenedUuid = serviceUuid == null ? "" : serviceUuid;
        }
        return DigestUtils.md5Hex((String)(dataHash + shortenedUuid));
    }
}

