/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.logic.keep;

import java.io.File;
import java.util.Map;
import org.arvados.client.api.client.KeepServerApiClient;
import org.arvados.client.config.ConfigProvider;
import org.arvados.client.exception.ArvadosApiException;
import org.arvados.client.logic.keep.KeepLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferHandler {
    private final String host;
    private final KeepServerApiClient keepServerApiClient;
    private final Map<String, String> headers;
    private final Logger log = LoggerFactory.getLogger(FileTransferHandler.class);

    public FileTransferHandler(String host, Map<String, String> headers, ConfigProvider config) {
        this.host = host;
        this.headers = headers;
        this.keepServerApiClient = new KeepServerApiClient(config);
    }

    public String put(String hashString, File body) {
        String url = this.host + hashString;
        String locator = null;
        try {
            locator = this.keepServerApiClient.upload(url, this.headers, body);
        }
        catch (ArvadosApiException e) {
            this.log.error("Cannot upload file to Keep server.", (Throwable)e);
        }
        return locator;
    }

    public byte[] get(KeepLocator locator) {
        return this.get(locator.stripped(), locator.permissionHint());
    }

    public byte[] get(String blockLocator, String authToken) {
        String url = this.host + blockLocator + "+" + authToken;
        try {
            return this.keepServerApiClient.download(url);
        }
        catch (ArvadosApiException e) {
            this.log.error("Cannot download file from Keep server.", (Throwable)e);
            return null;
        }
    }
}

