/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.logic.collection;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.arvados.client.api.client.GroupsApiClient;
import org.arvados.client.api.client.UsersApiClient;
import org.arvados.client.api.model.Collection;
import org.arvados.client.api.model.Group;
import org.arvados.client.api.model.User;
import org.arvados.client.config.ConfigProvider;
import org.arvados.client.config.FileConfigProvider;
import org.arvados.client.exception.ArvadosApiException;
import org.arvados.client.exception.ArvadosClientException;
import org.arvados.client.logic.collection.ManifestFactory;

public class CollectionFactory {
    private ConfigProvider config;
    private UsersApiClient usersApiClient;
    private GroupsApiClient groupsApiClient;
    private final String name;
    private final String projectUuid;
    private final List<File> manifestFiles;
    private final List<String> manifestLocators;

    private CollectionFactory(ConfigProvider config, String name, String projectUuid, List<File> manifestFiles, List<String> manifestLocators) {
        this.name = name;
        this.projectUuid = projectUuid;
        this.manifestFiles = manifestFiles;
        this.manifestLocators = manifestLocators;
        this.config = config;
        this.setApiClients();
    }

    public static CollectionFactoryBuilder builder() {
        return new CollectionFactoryBuilder();
    }

    private void setApiClients() {
        if (this.config == null) {
            this.config = new FileConfigProvider();
        }
        this.usersApiClient = new UsersApiClient(this.config);
        this.groupsApiClient = new GroupsApiClient(this.config);
    }

    public Collection create() {
        ManifestFactory manifestFactory = ManifestFactory.builder().files(this.manifestFiles).locators(this.manifestLocators).build();
        String manifest = manifestFactory.create();
        Collection newCollection = new Collection();
        newCollection.setName(this.getNameOrDefault(this.name));
        newCollection.setManifestText(manifest);
        newCollection.setOwnerUuid(this.getDesiredProjectUuid(this.projectUuid));
        return newCollection;
    }

    private String getNameOrDefault(String name) {
        return Optional.ofNullable(name).orElseGet(() -> {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("Y-MM-dd HH:mm:ss.SSS");
            return String.format("New Collection (%s)", dateTime.format(formatter));
        });
    }

    public String getDesiredProjectUuid(String projectUuid) {
        try {
            if (projectUuid == null || projectUuid.length() == 0) {
                return this.usersApiClient.current().getUuid();
            }
            if (projectUuid.matches("[a-z0-9]{5}-tpzed-[a-z0-9]{15}")) {
                return ((User)this.usersApiClient.get(projectUuid)).getUuid();
            }
            if (projectUuid.matches("[a-z0-9]{5}-j7d0g-[a-z0-9]{15}")) {
                return ((Group)this.groupsApiClient.get(projectUuid)).getUuid();
            }
        }
        catch (ArvadosApiException e) {
            throw new ArvadosClientException(String.format("An error occurred while getting project by UUID %s", projectUuid));
        }
        throw new ArvadosClientException(String.format("No project with %s UUID found", projectUuid));
    }

    public static class CollectionFactoryBuilder {
        private ConfigProvider config;
        private String name;
        private String projectUuid;
        private List<File> manifestFiles;
        private List<String> manifestLocators;

        CollectionFactoryBuilder() {
        }

        public CollectionFactoryBuilder config(ConfigProvider config) {
            this.config = config;
            return this;
        }

        public CollectionFactoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CollectionFactoryBuilder projectUuid(String projectUuid) {
            this.projectUuid = projectUuid;
            return this;
        }

        public CollectionFactoryBuilder manifestFiles(List<File> manifestFiles) {
            this.manifestFiles = manifestFiles;
            return this;
        }

        public CollectionFactoryBuilder manifestLocators(List<String> manifestLocators) {
            this.manifestLocators = manifestLocators;
            return this;
        }

        public CollectionFactory build() {
            return new CollectionFactory(this.config, this.name, this.projectUuid, this.manifestFiles, this.manifestLocators);
        }
    }
}

