/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.facade;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.arvados.client.api.client.CollectionsApiClient;
import org.arvados.client.api.client.GroupsApiClient;
import org.arvados.client.api.client.KeepWebApiClient;
import org.arvados.client.api.client.UsersApiClient;
import org.arvados.client.api.model.Collection;
import org.arvados.client.api.model.CollectionList;
import org.arvados.client.api.model.Group;
import org.arvados.client.api.model.GroupList;
import org.arvados.client.api.model.User;
import org.arvados.client.api.model.argument.Filter;
import org.arvados.client.api.model.argument.ListArgument;
import org.arvados.client.config.ConfigProvider;
import org.arvados.client.config.FileConfigProvider;
import org.arvados.client.logic.collection.FileToken;
import org.arvados.client.logic.collection.ManifestDecoder;
import org.arvados.client.logic.keep.FileDownloader;
import org.arvados.client.logic.keep.FileUploader;
import org.arvados.client.logic.keep.KeepClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArvadosFacade {
    private final ConfigProvider config;
    private final Logger log = LoggerFactory.getLogger(ArvadosFacade.class);
    private CollectionsApiClient collectionsApiClient;
    private GroupsApiClient groupsApiClient;
    private UsersApiClient usersApiClient;
    private FileDownloader fileDownloader;
    private FileUploader fileUploader;
    private static final String PROJECT = "project";
    private static final String SUBPROJECT = "sub-project";

    public ArvadosFacade(ConfigProvider config) {
        this.config = config;
        this.setFacadeFields();
    }

    public ArvadosFacade() {
        this.config = new FileConfigProvider();
        this.setFacadeFields();
    }

    private void setFacadeFields() {
        this.collectionsApiClient = new CollectionsApiClient(this.config);
        this.groupsApiClient = new GroupsApiClient(this.config);
        this.usersApiClient = new UsersApiClient(this.config);
        KeepClient keepClient = new KeepClient(this.config);
        ManifestDecoder manifestDecoder = new ManifestDecoder();
        KeepWebApiClient keepWebApiClient = new KeepWebApiClient(this.config);
        this.fileDownloader = new FileDownloader(keepClient, manifestDecoder, this.collectionsApiClient, keepWebApiClient);
        this.fileUploader = new FileUploader(keepClient, this.collectionsApiClient, this.config);
    }

    public File downloadFile(String filePathName, String collectionUuid, String pathToDownloadFolder) {
        return this.fileDownloader.downloadSingleFileUsingKeepWeb(filePathName, collectionUuid, pathToDownloadFolder);
    }

    public List<File> downloadCollectionFiles(String collectionUuid, String pathToDownloadFolder, boolean usingKeepWeb) {
        if (usingKeepWeb) {
            return this.fileDownloader.downloadFilesFromCollectionUsingKeepWeb(collectionUuid, pathToDownloadFolder);
        }
        return this.fileDownloader.downloadFilesFromCollection(collectionUuid, pathToDownloadFolder);
    }

    public List<FileToken> listFileInfoFromCollection(String collectionUuid) {
        return this.fileDownloader.listFileInfoFromCollection(collectionUuid);
    }

    public Collection upload(List<File> files) {
        return this.upload(files, null, null);
    }

    public Collection upload(File file) {
        return this.upload(Collections.singletonList(file), null, null);
    }

    public Collection upload(List<File> sourceFiles, String collectionName, String projectUuid) {
        return this.fileUploader.upload(sourceFiles, collectionName, projectUuid);
    }

    public Collection uploadToExistingCollection(File file, String collectionUUID) {
        return this.fileUploader.uploadToExistingCollection(Collections.singletonList(file), collectionUUID);
    }

    public Collection uploadToExistingCollection(List<File> files, String collectionUUID) {
        return this.fileUploader.uploadToExistingCollection(files, collectionUUID);
    }

    public Collection createEmptyCollection(String collectionName, String projectUuid) {
        Collection collection = new Collection();
        collection.setOwnerUuid(projectUuid);
        collection.setName(collectionName);
        return this.collectionsApiClient.create(collection);
    }

    public User getCurrentUser() {
        return this.usersApiClient.current();
    }

    public GroupList showGroupsOwnedByCurrentUser() {
        ListArgument listArgument = ListArgument.builder().filters(Arrays.asList(Filter.of("owner_uuid", Filter.Operator.LIKE, this.getCurrentUser().getUuid()), Filter.of("group_class", Filter.Operator.IN, Lists.newArrayList((Object[])new String[]{PROJECT, SUBPROJECT})))).build();
        GroupList groupList = (GroupList)this.groupsApiClient.list(listArgument);
        this.log.debug("Groups owned by user:");
        groupList.getItems().forEach(m -> this.log.debug(m.getUuid() + " -- " + m.getName()));
        return groupList;
    }

    public GroupList showGroupsAccessibleByCurrentUser() {
        ListArgument listArgument = ListArgument.builder().filters(Collections.singletonList(Filter.of("group_class", Filter.Operator.IN, Lists.newArrayList((Object[])new String[]{PROJECT, SUBPROJECT})))).build();
        GroupList groupList = (GroupList)this.groupsApiClient.list(listArgument);
        this.log.debug("Groups accessible by user:");
        groupList.getItems().forEach(m -> this.log.debug(m.getUuid() + " -- " + m.getName()));
        return groupList;
    }

    public CollectionList getCollectionsFromProjectByName(String collectionName, String projectUuid) {
        ListArgument listArgument = ListArgument.builder().filters(Arrays.asList(Filter.of("owner_uuid", Filter.Operator.LIKE, projectUuid), Filter.of("name", Filter.Operator.LIKE, collectionName))).order(Collections.singletonList("created_at")).build();
        return (CollectionList)this.collectionsApiClient.list(listArgument);
    }

    public Group getProjectByUuid(String projectUuid) {
        Group project = (Group)this.groupsApiClient.get(projectUuid);
        this.log.debug("Retrieved " + project.getName() + " with UUID: " + project.getUuid());
        return project;
    }

    public Group createNewProject(String projectName) {
        Group project = new Group();
        project.setName(projectName);
        project.setGroupClass(PROJECT);
        Group createdProject = this.groupsApiClient.create(project);
        this.log.debug("Project " + createdProject.getName() + " created with UUID: " + createdProject.getUuid());
        return createdProject;
    }

    public Collection deleteCollection(String collectionUuid) {
        Collection deletedCollection = (Collection)this.collectionsApiClient.delete(collectionUuid);
        this.log.debug("Collection: " + collectionUuid + " deleted.");
        return deletedCollection;
    }
}

