/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import okhttp3.Request;
import org.arvados.client.api.client.BaseStandardApiClient;
import org.arvados.client.api.model.User;
import org.arvados.client.api.model.UserList;
import org.arvados.client.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersApiClient
extends BaseStandardApiClient<User, UserList> {
    private static final String RESOURCE = "users";
    private final Logger log = LoggerFactory.getLogger(UsersApiClient.class);

    public UsersApiClient(ConfigProvider config) {
        super(config);
    }

    public User current() {
        this.log.debug("Get current {}", (Object)this.getType().getSimpleName());
        Request request = this.getNoArgumentMethodRequest("current");
        return (User)this.callForType(request);
    }

    public User system() {
        this.log.debug("Get system {}", (Object)this.getType().getSimpleName());
        Request request = this.getNoArgumentMethodRequest("system");
        return (User)this.callForType(request);
    }

    @Override
    String getResource() {
        return RESOURCE;
    }

    @Override
    Class<User> getType() {
        return User.class;
    }

    @Override
    Class<UserList> getListType() {
        return UserList.class;
    }
}

