/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import java.io.File;
import java.io.InputStream;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.arvados.client.api.client.BaseApiClient;
import org.arvados.client.api.client.CountingFileRequestBody;
import org.arvados.client.api.client.CountingStreamRequestBody;
import org.arvados.client.api.client.ProgressListener;
import org.arvados.client.config.ConfigProvider;

public class KeepWebApiClient
extends BaseApiClient {
    public KeepWebApiClient(ConfigProvider config) {
        super(config);
    }

    public byte[] download(String collectionUuid, String filePathName) {
        Request request = this.getRequestBuilder().url(this.getUrlBuilder(collectionUuid, filePathName).build()).get().build();
        return this.newFileCall(request);
    }

    public String delete(String collectionUuid, String filePathName) {
        Request request = this.getRequestBuilder().url(this.getUrlBuilder(collectionUuid, filePathName).build()).delete().build();
        return this.newCall(request);
    }

    public String upload(String collectionUuid, File file, ProgressListener progressListener) {
        CountingFileRequestBody requestBody = new CountingFileRequestBody(file, progressListener);
        Request request = this.getRequestBuilder().url(this.getUrlBuilder(collectionUuid, file.getName()).build()).put((RequestBody)requestBody).build();
        return this.newCall(request);
    }

    public String upload(String collectionUuid, InputStream inputStream, String fileName, ProgressListener progressListener) {
        CountingStreamRequestBody requestBody = new CountingStreamRequestBody(inputStream, progressListener);
        Request request = this.getRequestBuilder().url(this.getUrlBuilder(collectionUuid, fileName).build()).put((RequestBody)requestBody).build();
        return this.newCall(request);
    }

    private HttpUrl.Builder getUrlBuilder(String collectionUuid, String filePathName) {
        return new HttpUrl.Builder().scheme(this.config.getApiProtocol()).host(this.config.getKeepWebHost()).port(this.config.getKeepWebPort()).addPathSegment("c=" + collectionUuid).addPathSegment(filePathName);
    }
}

