/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import java.io.File;
import java.util.Map;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.arvados.client.api.client.BaseApiClient;
import org.arvados.client.api.client.CountingFileRequestBody;
import org.arvados.client.api.client.CountingRequestBody;
import org.arvados.client.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepServerApiClient
extends BaseApiClient {
    private final Logger log = LoggerFactory.getLogger(KeepServerApiClient.class);

    public KeepServerApiClient(ConfigProvider config) {
        super(config);
    }

    public String upload(String url, Map<String, String> headers, File body) {
        this.log.debug("Upload file {} to server location {}", (Object)body, (Object)url);
        CountingRequestBody.TransferData transferData = new CountingRequestBody.TransferData(body.length());
        CountingFileRequestBody requestBody = new CountingFileRequestBody(body, transferData::updateTransferProgress);
        Request request = this.getRequestBuilder().url(url).addHeader("X-Keep-Desired-Replicas", headers.get("X-Keep-Desired-Replicas")).put((RequestBody)requestBody).build();
        return this.newCall(request);
    }

    public byte[] download(String url) {
        Request request = this.getRequestBuilder().url(url).get().build();
        return this.newFileCall(request);
    }
}

