/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.arvados.client.api.client.BaseStandardApiClient;
import org.arvados.client.api.model.Group;
import org.arvados.client.api.model.GroupList;
import org.arvados.client.api.model.argument.ContentsGroup;
import org.arvados.client.api.model.argument.UntrashGroup;
import org.arvados.client.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupsApiClient
extends BaseStandardApiClient<Group, GroupList> {
    private static final String RESOURCE = "groups";
    private final Logger log = LoggerFactory.getLogger(GroupsApiClient.class);

    public GroupsApiClient(ConfigProvider config) {
        super(config);
    }

    public GroupList contents(ContentsGroup contentsGroup) {
        this.log.debug("Get {} contents", (Object)this.getType().getSimpleName());
        HttpUrl.Builder urlBuilder = this.getUrlBuilder().addPathSegment("contents");
        this.addQueryParameters(urlBuilder, contentsGroup);
        HttpUrl url = urlBuilder.build();
        Request request = this.getRequestBuilder().url(url).build();
        return (GroupList)this.callForList(request);
    }

    public Group untrash(UntrashGroup untrashGroup) {
        this.log.debug("Untrash {} by UUID {}", (Object)this.getType().getSimpleName(), (Object)untrashGroup.getUuid());
        HttpUrl url = this.getUrlBuilder().addPathSegment(untrashGroup.getUuid()).addPathSegment("untrash").build();
        RequestBody requestBody = this.getJsonRequestBody(untrashGroup);
        Request request = this.getRequestBuilder().post(requestBody).url(url).build();
        return (Group)this.callForType(request);
    }

    @Override
    String getResource() {
        return RESOURCE;
    }

    @Override
    Class<Group> getType() {
        return Group.class;
    }

    @Override
    Class<GroupList> getListType() {
        return GroupList.class;
    }
}

