/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import org.arvados.client.api.client.BaseStandardApiClient;
import org.arvados.client.api.model.Collection;
import org.arvados.client.api.model.CollectionList;
import org.arvados.client.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsApiClient
extends BaseStandardApiClient<Collection, CollectionList> {
    private static final String RESOURCE = "collections";
    private final Logger log = LoggerFactory.getLogger(CollectionsApiClient.class);

    public CollectionsApiClient(ConfigProvider config) {
        super(config);
    }

    @Override
    public Collection create(Collection type) {
        Collection newCollection = super.create(type);
        this.log.debug(String.format("New collection '%s' with UUID %s has been created", newCollection.getName(), newCollection.getUuid()));
        return newCollection;
    }

    @Override
    String getResource() {
        return RESOURCE;
    }

    @Override
    Class<Collection> getType() {
        return Collection.class;
    }

    @Override
    Class<CollectionList> getListType() {
        return CollectionList.class;
    }
}

