/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.arvados.client.api.client.BaseApiClient;
import org.arvados.client.api.model.Item;
import org.arvados.client.api.model.ItemList;
import org.arvados.client.api.model.argument.ListArgument;
import org.arvados.client.config.ConfigProvider;
import org.arvados.client.exception.ArvadosApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStandardApiClient<T extends Item, L extends ItemList>
extends BaseApiClient {
    private static final okhttp3.MediaType JSON = okhttp3.MediaType.parse((String)MediaType.JSON_UTF_8.toString());
    private final Logger log = LoggerFactory.getLogger(BaseStandardApiClient.class);

    BaseStandardApiClient(ConfigProvider config) {
        super(config);
    }

    public L list(ListArgument listArguments) {
        this.log.debug("Get list of {}", (Object)this.getType().getSimpleName());
        HttpUrl.Builder urlBuilder = this.getUrlBuilder();
        this.addQueryParameters(urlBuilder, listArguments);
        HttpUrl url = urlBuilder.build();
        Request request = this.getRequestBuilder().url(url).build();
        return this.callForList(request);
    }

    public L list() {
        return this.list(ListArgument.builder().build());
    }

    public T get(String uuid) {
        this.log.debug("Get {} by UUID {}", (Object)this.getType().getSimpleName(), (Object)uuid);
        HttpUrl url = this.getUrlBuilder().addPathSegment(uuid).build();
        Request request = this.getRequestBuilder().get().url(url).build();
        return this.callForType(request);
    }

    public T create(T type) {
        this.log.debug("Create {}", (Object)this.getType().getSimpleName());
        String json = this.mapToJson(type);
        RequestBody body = RequestBody.create((okhttp3.MediaType)JSON, (String)json);
        Request request = this.getRequestBuilder().post(body).build();
        return this.callForType(request);
    }

    public T delete(String uuid) {
        this.log.debug("Delete {} by UUID {}", (Object)this.getType().getSimpleName(), (Object)uuid);
        HttpUrl url = this.getUrlBuilder().addPathSegment(uuid).build();
        Request request = this.getRequestBuilder().delete().url(url).build();
        return this.callForType(request);
    }

    public T update(T type) {
        String uuid = ((Item)type).getUuid();
        this.log.debug("Update {} by UUID {}", (Object)this.getType().getSimpleName(), (Object)uuid);
        String json = this.mapToJson(type);
        RequestBody body = RequestBody.create((okhttp3.MediaType)JSON, (String)json);
        HttpUrl url = this.getUrlBuilder().addPathSegment(uuid).build();
        Request request = this.getRequestBuilder().put(body).url(url).build();
        return this.callForType(request);
    }

    @Override
    Request.Builder getRequestBuilder() {
        return super.getRequestBuilder().url(this.getUrlBuilder().build());
    }

    HttpUrl.Builder getUrlBuilder() {
        return new HttpUrl.Builder().scheme(this.config.getApiProtocol()).host(this.config.getApiHost()).port(this.config.getApiPort()).addPathSegment("arvados").addPathSegment("v1").addPathSegment(this.getResource());
    }

    <TL> TL call(Request request, Class<TL> cls) {
        String bodyAsString = this.newCall(request);
        try {
            return this.mapToObject(bodyAsString, cls);
        }
        catch (IOException e) {
            throw new ArvadosApiException("A problem occurred while parsing JSON data", e);
        }
    }

    private <TL> TL mapToObject(String content, Class<TL> cls) throws IOException {
        return (TL)MAPPER.readValue(content, cls);
    }

    private <TL> String mapToJson(TL type) {
        ObjectWriter writer = MAPPER.writer().withDefaultPrettyPrinter();
        try {
            return writer.writeValueAsString(type);
        }
        catch (JsonProcessingException e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    T callForType(Request request) {
        return (T)((Item)this.call(request, this.getType()));
    }

    L callForList(Request request) {
        return (L)((ItemList)this.call(request, this.getListType()));
    }

    abstract String getResource();

    abstract Class<T> getType();

    abstract Class<L> getListType();

    Request getNoArgumentMethodRequest(String method) {
        HttpUrl url = this.getUrlBuilder().addPathSegment(method).build();
        return this.getRequestBuilder().get().url(url).build();
    }

    RequestBody getJsonRequestBody(Object object) {
        return RequestBody.create((okhttp3.MediaType)JSON, (String)this.mapToJson(object));
    }

    void addQueryParameters(HttpUrl.Builder urlBuilder, Object object) {
        Map queryMap = (Map)MAPPER.convertValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){});
        queryMap.keySet().forEach(key -> {
            Object type = queryMap.get(key);
            if (!(type instanceof String)) {
                type = this.mapToJson(type);
            }
            urlBuilder.addQueryParameter(key, (String)type);
        });
    }
}

