/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.arvados.client.api.client.factory.OkHttpClientFactory;
import org.arvados.client.api.model.ApiError;
import org.arvados.client.config.ConfigProvider;
import org.arvados.client.exception.ArvadosApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseApiClient {
    static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    final OkHttpClient client;
    final ConfigProvider config;
    private final Logger log = LoggerFactory.getLogger(BaseApiClient.class);

    BaseApiClient(ConfigProvider config) {
        this.config = config;
        this.client = OkHttpClientFactory.INSTANCE.create(config.isApiHostInsecure()).newBuilder().connectTimeout((long)config.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.MILLISECONDS).build();
    }

    Request.Builder getRequestBuilder() {
        return new Request.Builder().addHeader("authorization", String.format("OAuth2 %s", this.config.getApiToken())).addHeader("cache-control", "no-cache");
    }

    String newCall(Request request) {
        return (String)this.getResponseBody(request, body -> body.string().trim());
    }

    byte[] newFileCall(Request request) {
        return (byte[])this.getResponseBody(request, ResponseBody::bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getResponseBody(Request request, Command command) {
        try {
            this.log.debug(URLDecoder.decode(request.toString(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new ArvadosApiException(e);
        }
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody responseBody = response.body();
            if (!response.isSuccessful()) {
                String errorBody = Objects.requireNonNull(responseBody).string();
                if (errorBody != null && errorBody.length() != 0) {
                    ApiError apiError = (ApiError)MAPPER.readValue(errorBody, ApiError.class);
                    throw new ArvadosApiException(String.format("Error code %s with messages: %s", response.code(), apiError.getErrors()));
                }
                throw new ArvadosApiException(String.format("Error code %s with message: %s", response.code(), response.message()));
            }
            Object object = command.readResponseBody(responseBody);
            return object;
        }
        catch (IOException e) {
            throw new ArvadosApiException(e);
        }
    }

    private static interface Command {
        public Object readResponseBody(ResponseBody var1) throws IOException;
    }
}

