/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.simpleclient;

import java.io.InputStream;
import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.query.QueryResultSet;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.query.ArtifactSummary;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;

public class SimpleClientDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/artificer-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "artificer1!";
    private static final String[] FILES = new String[]{"ws-humantask.xsd", "ws-humantask-context.xsd", "ws-humantask-policy.xsd", "ws-humantask-types.xsd", "ws-humantask-leantask-api.wsdl", "ws-humantask-protocol.wsdl"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running Artificer Simple Client Demo ***\n");
        String endpoint = System.getProperty("artificer.endpoint");
        String username = System.getProperty("artificer.auth.username");
        String password = System.getProperty("artificer.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("Artificer Endpoint: " + endpoint);
        System.out.println("Artificer User: " + username);
        ArtificerAtomApiClient client = new ArtificerAtomApiClient(endpoint, username, password, true);
        QueryResultSet rs = client.buildQuery("/s-ramp[@from-demo = ?]").parameter(SimpleClientDemo.class.getSimpleName()).count(1).query();
        if (rs.size() > 0L) {
            System.out.println("It looks like you already ran this demo!");
            System.out.println("I'm going to quit, because I don't want to clutter up");
            System.out.println("your repository with duplicate stuff.");
            System.exit(1);
        }
        System.out.println("Uploading some XML schemas...");
        for (String file : FILES) {
            try (InputStream is = SimpleClientDemo.class.getResourceAsStream(file);){
                ArtifactType type = ArtifactType.XsdDocument();
                if (file.endsWith(".wsdl")) {
                    type = ArtifactType.WsdlDocument();
                }
                System.out.print("\tUploading artifact " + file + "...");
                BaseArtifactType artifact = client.uploadArtifact(type, is, file);
                System.out.println("done.");
                artifact.setVersion("1.1");
                ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"from-demo", (String)SimpleClientDemo.class.getSimpleName());
                System.out.print("\tUpdating meta-data for artifact " + file + "...");
                client.updateArtifactMetaData(artifact);
                System.out.println("done.");
            }
        }
        System.out.print("Querying the Artificer repository for Schemas...");
        QueryResultSet rset = client.query("/s-ramp/xsd/XsdDocument");
        System.out.println("success: " + rset.size() + " Schemas found:");
        for (ArtifactSummary entry : rset) {
            System.out.println("\t * " + entry.getName() + " (" + entry.getUuid() + ")");
        }
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }
}

