/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.ontologies;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.ontology.OntologySummary;

public class OntologyDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/artificer-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "artificer1!";

    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running Artificer Ontology Demo ***\n");
        String endpoint = System.getProperty("artificer.endpoint");
        String username = System.getProperty("artificer.auth.username");
        String password = System.getProperty("artificer.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("Artificer Endpoint: " + endpoint);
        System.out.println("Artificer User: " + username);
        ArtificerAtomApiClient client = new ArtificerAtomApiClient(endpoint, username, password, true);
        System.out.println("Searching for ontologies.");
        List ontologies = client.getOntologies();
        HashSet<String> foundOntologies = new HashSet<String>();
        if (ontologies.isEmpty()) {
            System.out.println("No ontologies found (good).");
        } else {
            System.out.println("Found some ontologies (ok):");
            for (Object ontology : ontologies) {
                System.out.println("  " + ontology.getBase());
                foundOntologies.add(ontology.getBase());
            }
        }
        if (!foundOntologies.contains("http://www.example.org/sample-ontology-1.owl")) {
            System.out.print("Uploading sample ontology 1...");
            client.uploadOntology(OntologyDemo.class.getResourceAsStream("sample-ontology-1.owl.xml"));
            System.out.println("done.");
        }
        if (!foundOntologies.contains("http://www.example.org/sample-ontology-2.owl")) {
            System.out.print("Uploading sample ontology 2...");
            client.uploadOntology(OntologyDemo.class.getResourceAsStream("sample-ontology-2.owl.xml"));
            System.out.println("done.");
        }
        System.out.println("There should now be (at least) two ontologies in the repo.");
        System.out.print("Checking for ontologies...");
        ontologies = client.getOntologies();
        System.out.printf("found %1$d:\n", ontologies.size());
        HashMap<String, String> ontologyUuids = new HashMap<String, String>();
        for (OntologySummary ontology : ontologies) {
            System.out.println("  " + ontology.getBase());
            ontologyUuids.put(ontology.getBase(), ontology.getUuid());
        }
        String sampleOntology2Uuid = (String)ontologyUuids.get("http://www.example.org/sample-ontology-2.owl");
        System.out.print("Deleting sample-ontology-2...");
        client.deleteOntology(sampleOntology2Uuid);
        System.out.println("deleted.");
        System.out.println("There should now be one less ontology in the repo.");
        System.out.print("Checking for ontologies...");
        ontologies = client.getOntologies();
        System.out.printf("found %1$d:\n", ontologies.size());
        for (OntologySummary ontology : ontologies) {
            System.out.println("  " + ontology.getBase());
            ontologyUuids.put(ontology.getBase(), ontology.getUuid());
        }
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }
}

