/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.artifactbuilder;

import java.io.InputStream;
import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.query.QueryResultSet;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;

public class CustomArtifactBuilderDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/artificer-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "artificer1!";

    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running S-RAMP Customer ArtifactBuilder Demo ***\n");
        String endpoint = System.getProperty("artificer.endpoint");
        String username = System.getProperty("artificer.auth.username");
        String password = System.getProperty("artificer.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("Artificer Endpoint: " + endpoint);
        System.out.println("Artificer User: " + username);
        ArtificerAtomApiClient client = new ArtificerAtomApiClient(endpoint, username, password, true);
        QueryResultSet rs = client.buildQuery("/s-ramp[@from-demo = ?]").parameter(CustomArtifactBuilderDemo.class.getSimpleName()).count(1).query();
        if (rs.size() > 0L) {
            System.out.println("It looks like you already ran this demo!");
            System.out.println("I'm going to quit, because I don't want to clutter up");
            System.out.println("your repository with duplicate stuff.");
            System.exit(1);
        }
        String webXmlArtifactUUID = CustomArtifactBuilderDemo.addWebXmlToRepository(client);
        CustomArtifactBuilderDemo.queryForDerivedArtifacts(client, webXmlArtifactUUID);
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }

    private static String addWebXmlToRepository(ArtificerAtomApiClient client) throws Exception {
        System.out.println("Adding the sample 'web.xml' artifact to the repository.");
        InputStream webXmlIS = CustomArtifactBuilderDemo.class.getResourceAsStream("web.xml");
        ArtifactType artifactType = ArtifactType.valueOf((String)"WebXmlDocument");
        BaseArtifactType artifact = client.uploadArtifact(artifactType, webXmlIS, "web.xml");
        System.out.println("Sample 'web.xml' artifact successfully added.");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"from-demo", (String)CustomArtifactBuilderDemo.class.getSimpleName());
        client.updateArtifactMetaData(artifact);
        System.out.println("Sample 'web.xml' artifact successfully updated.");
        return artifact.getUuid();
    }

    private static void queryForDerivedArtifacts(ArtificerAtomApiClient client, String webXmlArtifactUUID) throws Exception {
        System.out.println("Querying the repository to verify derived web.xml content.");
        String query = String.format("/s-ramp/ext/WebXmlDocument[@uuid = '%1$s']", webXmlArtifactUUID);
        System.out.println("\t" + query);
        QueryResultSet resultSet = client.query(query);
        if (resultSet.size() != 1L) {
            throw new Exception("Error querying for the original web.xml artifact!");
        }
        System.out.println("Querying the repository for all web.xml derived artifacts.");
        query = String.format("/s-ramp/ext[relatedDocument[@uuid = '%1$s']]", webXmlArtifactUUID);
        System.out.println("\t" + query);
        resultSet = client.query(query);
        if (resultSet.size() != 12L) {
            throw new Exception("Expected 12 derived artifacts but found only " + resultSet.size() + "!");
        }
    }
}

