/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.artificer.atom.ArtificerAtomUtils;
import org.artificer.atom.err.ArtificerAtomException;
import org.artificer.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.ArtifactVerifier;
import org.artificer.common.ArtificerConfig;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.common.error.ArtificerUserException;
import org.artificer.common.visitors.ArtifactVisitor;
import org.artificer.common.visitors.ArtifactVisitorHelper;
import org.artificer.events.EventProducer;
import org.artificer.events.EventProducerFactory;
import org.artificer.repository.PersistenceManager;
import org.artificer.repository.RepositoryProviderFactory;
import org.artificer.server.ArtifactServiceImpl;
import org.artificer.server.atom.services.AbstractResource;
import org.artificer.server.atom.services.ArtifactResource;
import org.artificer.server.i18n.Messages;
import org.artificer.server.mime.MimeTypes;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;
import org.jboss.resteasy.util.GenericType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/s-ramp")
public class ArtifactResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(ArtifactResource.class);
    private static final ThreadLocal<SimpleDateFormat> dateFormat = new /* Unavailable Anonymous Inner Class!! */;
    private final ArtifactServiceImpl artifactService = new ArtifactServiceImpl();

    @POST
    @Path(value="{model}/{type}")
    @Consumes(value={"application/atom+xml;type=entry"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, Entry entry) throws ArtificerServerException {
        try {
            BaseArtifactType artifact = ArtificerAtomUtils.unwrapSrampArtifact((Entry)entry);
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            BaseArtifactType persistedArtifact = this.artifactService.create(artifactType, artifact);
            return this.wrapArtifact(persistedArtifact, request);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @POST
    @Path(value="{model}/{type}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, InputStream is) throws ArtificerAtomException {
        try {
            BaseArtifactType artifact = this.artifactService.upload(model, type, fileName, is);
            Entry entry = this.wrapArtifact(artifact, request);
            return entry;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new ArtificerAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @POST
    @Path(value="{model}/{type}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, String path) throws ArtificerAtomException {
        Entry entry;
        FileInputStream is = null;
        try {
            File file = new File(path);
            is = new FileInputStream(file);
            BaseArtifactType artifact = this.artifactService.upload(model, type, file.getName(), (InputStream)is);
            entry = this.wrapArtifact(artifact, request);
        }
        catch (Exception e) {
            try {
                ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
                throw new ArtificerAtomException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return entry;
    }

    @POST
    @Path(value="autodetect")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, InputStream is) throws ArtificerAtomException {
        try {
            if (StringUtils.isEmpty((String)fileName)) {
                throw ArtificerUserException.filenameRequired();
            }
            BaseArtifactType artifact = this.artifactService.upload(fileName, is);
            Entry entry = this.wrapArtifact(artifact, request);
            return entry;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new ArtificerAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @POST
    @Path(value="autodetect")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, String path) throws ArtificerAtomException {
        Entry entry;
        FileInputStream is = null;
        try {
            File file = new File(path);
            is = new FileInputStream(file);
            BaseArtifactType artifact = this.artifactService.upload(file.getName(), (InputStream)is);
            entry = this.wrapArtifact(artifact, request);
        }
        catch (Exception e) {
            try {
                ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
                throw new ArtificerAtomException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return entry;
    }

    private Entry wrapArtifact(BaseArtifactType artifact, HttpServletRequest request) throws Exception {
        String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
        ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        return visitor.getAtomEntry();
    }

    @POST
    @Path(value="{model}/{type}")
    @Consumes(value={"multipart/related"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry createMultiPart(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, MultipartRelatedInput input) throws ArtificerServerException {
        try {
            List list;
            String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            if (artifactType.isDerived()) {
                throw ArtificerUserException.derivedArtifactCreate((ArtifactTypeEnum)artifactType.getArtifactType());
            }
            if (artifactType.isExtendedType()) {
                artifactType = ArtifactType.ExtendedDocument((String)artifactType.getExtendedType());
            }
            if ((list = input.getParts()).size() != 2) {
                throw new ArtificerAtomException(Messages.i18n.format("INVALID_MULTIPART_POST", new Object[]{list.size()}));
            }
            InputPart firstPart = (InputPart)list.get(0);
            InputPart secondpart = (InputPart)list.get(1);
            Entry atomEntry = (Entry)firstPart.getBody((GenericType)new /* Unavailable Anonymous Inner Class!! */);
            BaseArtifactType artifactMetaData = ArtificerAtomUtils.unwrapSrampArtifact((Entry)atomEntry);
            ArtifactVerifier verifier = new ArtifactVerifier(artifactType);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)verifier, (BaseArtifactType)artifactMetaData);
            verifier.throwError();
            String fileName = null;
            if (artifactMetaData.getName() != null) {
                fileName = artifactMetaData.getName();
            }
            ArtifactContent content = new ArtifactContent(fileName, (InputStream)secondpart.getBody((GenericType)new /* Unavailable Anonymous Inner Class!! */));
            String mimeType = MimeTypes.determineMimeType((String)fileName, (InputStream)content.getInputStream(), (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            PersistenceManager persistenceManager = RepositoryProviderFactory.persistenceManager();
            BaseArtifactType artifactRval = persistenceManager.persistArtifact(artifactMetaData, content);
            Set eventProducers = EventProducerFactory.getEventProducers();
            for (EventProducer eventProducer : eventProducers) {
                eventProducer.artifactCreated(artifactRval);
            }
            return this.wrapArtifact(artifactRval, request);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}")
    @Consumes(value={"application/atom+xml;type=entry"})
    public void updateMetaData(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, Entry atomEntry) throws ArtificerServerException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, null);
            if (artifactType.isExtendedType()) {
                artifactType = ArtificerAtomUtils.getArtifactType((Entry)atomEntry);
            }
            BaseArtifactType updatedArtifact = ArtificerAtomUtils.unwrapSrampArtifact((Entry)atomEntry);
            this.artifactService.updateMetaData(artifactType, uuid, updatedArtifact);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_UPDATING_META_DATA", new Object[]{uuid}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }

    @POST
    @Path(value="{model}/{type}/{uuid}/comment")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry addComment(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, String text) throws ArtificerServerException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            BaseArtifactType artifact = this.artifactService.addComment(artifactType, uuid, text);
            return this.wrapArtifact(artifact, request);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_COMMENT", new Object[]{uuid}), (Throwable)e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry getMetaData(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws ArtificerServerException {
        try {
            BaseArtifactType artifact = this.artifactService.getMetaData(model, type, uuid);
            return this.wrapArtifact(artifact, request);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_META_DATA", new Object[]{uuid}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}/media")
    public Response getContent(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws ArtificerServerException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
            BaseArtifactType artifact = this.artifactService.getMetaData(artifactType, uuid);
            InputStream inputStream = this.artifactService.getContent(artifactType, artifact);
            4 output = new /* Unavailable Anonymous Inner Class!! */;
            String lastModifiedDate = ((SimpleDateFormat)dateFormat.get()).format(artifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
            return Response.ok((Object)output, (String)artifactType.getMimeType()).header("Content-Disposition", (Object)("attachment; filename=" + artifact.getName())).header("Content-Length", artifact.getOtherAttributes().get(ArtificerConstants.SRAMP_CONTENT_SIZE_QNAME)).header("Last-Modified", (Object)lastModifiedDate).build();
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_CONTENT", new Object[]{uuid}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }

    @DELETE
    @Path(value="{model}/{type}/{uuid}")
    public void delete(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws ArtificerServerException {
        try {
            this.artifactService.delete(model, type, uuid);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_DELETING_ARTY", new Object[]{uuid}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }

    @DELETE
    @Path(value="{model}/{type}/{uuid}/force")
    public void forceDelete(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws ArtificerServerException {
        try {
            this.artifactService.delete(model, type, uuid, true);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_DELETING_ARTY", new Object[]{uuid}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }
}

