/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import java.util.List;
import java.util.Set;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.common.ontology.OntologyValidator;
import org.artificer.events.EventProducer;
import org.artificer.events.EventProducerFactory;
import org.artificer.repository.PersistenceManager;
import org.artificer.server.AbstractServiceImpl;
import org.artificer.server.core.api.OntologyService;

@Stateful(name="OntologyService")
@Remote(value={OntologyService.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class OntologyServiceImpl
extends AbstractServiceImpl
implements OntologyService {
    public ArtificerOntology create(ArtificerOntology ontology) throws Exception {
        OntologyValidator.validateOntology((ArtificerOntology)ontology);
        PersistenceManager persistenceManager = this.persistenceManager();
        ontology = persistenceManager.persistOntology(ontology);
        Set eventProducers = EventProducerFactory.getEventProducers();
        for (EventProducer eventProducer : eventProducers) {
            eventProducer.ontologyCreated(ontology);
        }
        return ontology;
    }

    public void update(String uuid, ArtificerOntology ontology) throws Exception {
        OntologyValidator.validateOntology((ArtificerOntology)ontology);
        ArtificerOntology oldOntology = this.get(uuid);
        PersistenceManager persistenceManager = this.persistenceManager();
        persistenceManager.updateOntology(ontology);
        Set eventProducers = EventProducerFactory.getEventProducers();
        for (EventProducer eventProducer : eventProducers) {
            eventProducer.ontologyUpdated(ontology, oldOntology);
        }
    }

    public ArtificerOntology get(String uuid) throws Exception {
        return this.persistenceManager().getOntology(uuid);
    }

    public List<ArtificerOntology> get() throws Exception {
        return this.persistenceManager().getOntologies();
    }

    public void delete(String uuid) throws Exception {
        ArtificerOntology ontology = this.get(uuid);
        this.persistenceManager().deleteOntology(uuid);
        Set eventProducers = EventProducerFactory.getEventProducers();
        for (EventProducer eventProducer : eventProducers) {
            eventProducer.ontologyDeleted(ontology);
        }
    }
}

