/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.services;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.artificer.atom.archive.ArtificerArchive;
import org.artificer.atom.beans.HttpResponseBean;
import org.artificer.atom.err.ArtificerAtomException;
import org.artificer.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.artificer.common.ArtificerConfig;
import org.artificer.common.ArtificerException;
import org.artificer.common.MediaType;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.common.visitors.ArtifactVisitor;
import org.artificer.common.visitors.ArtifactVisitorHelper;
import org.artificer.server.BatchServiceImpl;
import org.artificer.server.atom.services.AbstractResource;
import org.artificer.server.core.api.BatchResult;
import org.artificer.server.i18n.Messages;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/s-ramp")
public class BatchResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(BatchResource.class);
    private final BatchServiceImpl batchService = new BatchServiceImpl();

    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"multipart/mixed"})
    @PartType(value="message/http")
    public MultipartOutput zipPackagePost(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, InputStream content) throws ArtificerAtomException, ArtificerException {
        return this.doZipPackage(request, content);
    }

    @PUT
    @Consumes(value={"application/zip"})
    @Produces(value={"multipart/mixed"})
    @PartType(value="message/http")
    public MultipartOutput zipPackagePut(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, InputStream content) throws ArtificerServerException {
        return this.doZipPackage(request, content);
    }

    private MultipartOutput doZipPackage(HttpServletRequest request, InputStream content) throws ArtificerServerException {
        ArtificerArchive archive = null;
        String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
        try {
            Entry atomEntry;
            ArtifactToFullAtomEntryVisitor visitor;
            archive = new ArtificerArchive(content);
            MultipartOutput output = new MultipartOutput();
            output.setBoundary("package");
            BatchResult batchResult = this.batchService.upload(archive);
            for (String batchItemId : batchResult.getCreates().keySet()) {
                visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
                ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)((BaseArtifactType)batchResult.getCreates().get(batchItemId)));
                atomEntry = visitor.getAtomEntry();
                this.addCreatedPart(output, batchItemId, atomEntry);
            }
            for (String batchItemId : batchResult.getUpdates().keySet()) {
                visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
                ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)((BaseArtifactType)batchResult.getUpdates().get(batchItemId)));
                atomEntry = visitor.getAtomEntry();
                this.addUpdatedPart(output, batchItemId, atomEntry);
            }
            for (String batchItemId : batchResult.getErrors().keySet()) {
                this.addErrorPart(output, batchItemId, (Exception)batchResult.getErrors().get(batchItemId));
            }
            MultipartOutput multipartOutput = output;
            return multipartOutput;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            BatchResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CONSUMING_ZIP", new Object[0]), (Throwable)e);
            throw new ArtificerAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
            if (archive != null) {
                ArtificerArchive.closeQuietly((ArtificerArchive)archive);
            }
        }
    }

    private void addCreatedPart(MultipartOutput output, String contentId, Entry atomEntry) {
        HttpResponseBean createdResponse = new HttpResponseBean(201, "Created");
        createdResponse.setBody((Object)atomEntry, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        output.addPart((Object)createdResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
    }

    private void addUpdatedPart(MultipartOutput output, String contentId, Entry atomEntry) {
        HttpResponseBean createdResponse = new HttpResponseBean(200, "OK");
        createdResponse.setBody((Object)atomEntry, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        output.addPart((Object)createdResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
    }

    private void addErrorPart(MultipartOutput output, String contentId, Exception error) {
        HttpResponseBean errorResponse = new HttpResponseBean(409, "Conflict");
        ArtificerAtomException e = new ArtificerAtomException((Throwable)error);
        errorResponse.setBody((Object)e, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ARTIFICER_SERVER_EXCEPTION_TYPE);
        output.addPart((Object)errorResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
    }
}

