/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.services;

import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.artificer.atom.ArtificerAtomUtils;
import org.artificer.atom.err.ArtificerAtomException;
import org.artificer.common.ArtificerConfig;
import org.artificer.common.MediaType;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.server.atom.services.AbstractFeedResource;
import org.artificer.server.i18n.Messages;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Link;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/s-ramp/query")
public class StoredQueryResource
extends AbstractFeedResource {
    private static Logger logger = LoggerFactory.getLogger(StoredQueryResource.class);

    @POST
    @Consumes(value={"application/atom+xml;type=entry"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, Entry atomEntry) throws ArtificerServerException {
        try {
            String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
            StoredQuery storedQuery = ArtificerAtomUtils.unwrapStoredQuery((Entry)atomEntry);
            storedQuery = this.queryService.createStoredQuery(storedQuery);
            return this.wrapStoredQuery(storedQuery, baseUrl);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_CREATING_STOREDQUERY", new Object[0]), e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{queryName}")
    @Consumes(value={"application/atom+xml;type=entry"})
    public void update(@PathParam(value="queryName") String queryName, Entry atomEntry) throws ArtificerServerException {
        try {
            StoredQuery storedQuery = ArtificerAtomUtils.unwrapStoredQuery((Entry)atomEntry);
            this.queryService.updateStoredQuery(queryName, storedQuery);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_UPDATING_STOREDQUERY", new Object[]{queryName}), e);
            throw new ArtificerAtomException(e);
        }
    }

    @GET
    @Path(value="{queryName}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry get(@Context HttpServletRequest request, @PathParam(value="queryName") String queryName) throws ArtificerServerException {
        try {
            String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
            StoredQuery storedQuery = this.queryService.getStoredQuery(queryName);
            return this.wrapStoredQuery(storedQuery, baseUrl);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_GETTING_STOREDQUERY", new Object[]{queryName}), e);
            throw new ArtificerAtomException(e);
        }
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed list(@Context HttpServletRequest request) throws ArtificerAtomException {
        try {
            String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
            List<StoredQuery> storedQueries = this.queryService.getStoredQueries();
            Feed feed = new Feed();
            feed.setTitle("S-RAMP Stored Queries Feed");
            feed.setUpdated(new Date());
            for (StoredQuery storedQuery : storedQueries) {
                feed.getEntries().add(this.wrapStoredQuery(storedQuery, baseUrl));
            }
            return feed;
        }
        catch (Exception e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_GETTING_STOREDQUERIES", new Object[0]), e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @GET
    @Path(value="{queryName}/results")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed getResults(@Context HttpServletRequest request, @PathParam(value="queryName") String queryName, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="ascending") Boolean asc) throws ArtificerServerException {
        try {
            String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
            StoredQuery storedQuery = this.queryService.getStoredQuery(queryName);
            return this.createArtifactFeed(storedQuery.getQueryExpression(), startPage, startIndex, count, orderBy, asc, new HashSet<String>(storedQuery.getPropertyName()), baseUrl);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_EXECUTING_STOREDQUERY", new Object[]{queryName}), e);
            throw new ArtificerAtomException(e);
        }
    }

    @DELETE
    @Path(value="{queryName}")
    public void delete(@PathParam(value="queryName") String queryName) throws ArtificerServerException {
        try {
            this.queryService.deleteStoredQuery(queryName);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_DELETING_STOREDQUERY", new Object[]{queryName}), e);
            throw new ArtificerAtomException(e);
        }
    }

    private Entry wrapStoredQuery(StoredQuery storedQuery, String baseUrl) throws Exception {
        Entry entry = ArtificerAtomUtils.wrapStoredQuery((StoredQuery)storedQuery);
        String atomLink = baseUrl + "/s-ramp/query/" + storedQuery.getQueryName();
        Link linkToSelf = new Link();
        linkToSelf.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        linkToSelf.setRel("self");
        linkToSelf.setHref(new URI(atomLink));
        entry.getLinks().add(linkToSelf);
        Link linkToEdit = new Link();
        linkToEdit.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        linkToEdit.setRel("edit");
        linkToEdit.setHref(new URI(atomLink));
        entry.getLinks().add(linkToEdit);
        Link linkToResults = new Link();
        linkToResults.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        linkToResults.setRel("urn:x-s-ramp:2013:query:results");
        linkToResults.setHref(new URI(atomLink + "/results"));
        entry.getLinks().add(linkToResults);
        return entry;
    }
}

