/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.services;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.artificer.atom.err.ArtificerAtomException;
import org.artificer.common.ArtificerConfig;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.server.atom.services.AbstractFeedResource;
import org.artificer.server.i18n.Messages;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.util.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/s-ramp")
public class QueryResource
extends AbstractFeedResource {
    private static Logger logger = LoggerFactory.getLogger(QueryResource.class);

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed queryFromGet(@Context HttpServletRequest request, @QueryParam(value="query") String query, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="ascending") Boolean asc, @QueryParam(value="propertyName") Set<String> propNames) throws ArtificerAtomException {
        try {
            String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
            return this.createArtifactFeed(query, startPage, startIndex, count, orderBy, asc, propNames, baseUrl);
        }
        catch (Throwable e) {
            QueryResource.logError(logger, Messages.i18n.format("ERROR_EXECUTING_QUERY", new Object[]{query}), e);
            throw new ArtificerAtomException(e);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed queryFromPost(@Context HttpServletRequest request, MultipartFormDataInput input) throws ArtificerServerException {
        String query = null;
        try {
            String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
            query = (String)input.getFormDataPart("query", (GenericType)new GenericType<String>(){});
            Integer startPage = (Integer)input.getFormDataPart("startPage", (GenericType)new GenericType<Integer>(){});
            Integer startIndex = (Integer)input.getFormDataPart("startIndex", (GenericType)new GenericType<Integer>(){});
            Integer count = (Integer)input.getFormDataPart("count", (GenericType)new GenericType<Integer>(){});
            String orderBy = (String)input.getFormDataPart("orderBy", (GenericType)new GenericType<String>(){});
            Boolean asc = (Boolean)input.getFormDataPart("ascending", (GenericType)new GenericType<Boolean>(){});
            HashSet<String> propNames = new HashSet<String>();
            List list = (List)input.getFormDataMap().get("propertyName");
            if (list != null) {
                for (InputPart inputPart : list) {
                    propNames.add(inputPart.getBodyAsString());
                }
            }
            return this.createArtifactFeed(query, startPage, startIndex, count, orderBy, asc, propNames, baseUrl);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            QueryResource.logError(logger, Messages.i18n.format("ERROR_EXECUTING_QUERY", new Object[]{query}), e);
            throw new ArtificerAtomException(e);
        }
    }
}

