/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.services;

import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.artificer.atom.ArtificerAtomUtils;
import org.artificer.atom.err.ArtificerAtomException;
import org.artificer.atom.mappers.OntologyToRdfMapper;
import org.artificer.atom.mappers.RdfToOntologyMapper;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.server.OntologyServiceImpl;
import org.artificer.server.atom.services.AbstractResource;
import org.artificer.server.core.api.OntologyService;
import org.artificer.server.i18n.Messages;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;

@Path(value="/s-ramp")
public class OntologyResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(OntologyResource.class);
    private static OntologyToRdfMapper o2rdf = new OntologyToRdfMapper();
    private static RdfToOntologyMapper rdf2o = new RdfToOntologyMapper();
    private final OntologyService ontologyService = new OntologyServiceImpl();

    @POST
    @Path(value="ontology")
    @Consumes(value={"application/rdf+xml"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(RDF rdf) throws ArtificerServerException {
        try {
            ArtificerOntology ontology = new ArtificerOntology();
            rdf2o.map(rdf, ontology);
            ontology = this.ontologyService.create(ontology);
            RDF responseRDF = new RDF();
            o2rdf.map(ontology, responseRDF);
            return ArtificerAtomUtils.wrapOntology((ArtificerOntology)ontology, (RDF)responseRDF);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            OntologyResource.logError(logger, Messages.i18n.format("ERROR_CREATING_ONTOLOGY", new Object[0]), e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @PUT
    @Path(value="ontology/{uuid}")
    @Consumes(value={"application/rdf+xml"})
    public void update(@PathParam(value="uuid") String uuid, RDF rdf) throws ArtificerServerException {
        try {
            ArtificerOntology ontology = new ArtificerOntology();
            rdf2o.map(rdf, ontology);
            ontology.setUuid(uuid);
            this.ontologyService.update(uuid, ontology);
            RDF updatedRDF = new RDF();
            o2rdf.map(ontology, updatedRDF);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            OntologyResource.logError(logger, Messages.i18n.format("ERROR_UPDATING_ONTOLOGY", new Object[]{uuid}), e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @GET
    @Path(value="ontology/{uuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry get(@PathParam(value="uuid") String uuid) throws ArtificerServerException {
        try {
            ArtificerOntology ontology = this.ontologyService.get(uuid);
            RDF responseRDF = new RDF();
            o2rdf.map(ontology, responseRDF);
            return ArtificerAtomUtils.wrapOntology((ArtificerOntology)ontology, (RDF)responseRDF);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            OntologyResource.logError(logger, Messages.i18n.format("ERROR_GETTING_ONTOLOGY", new Object[]{uuid}), e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="ontology/{uuid}")
    public void delete(@PathParam(value="uuid") String uuid) throws ArtificerServerException {
        try {
            this.ontologyService.delete(uuid);
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Exception e) {
            OntologyResource.logError(logger, Messages.i18n.format("ERROR_DELETING_ONTOLOGY", new Object[]{uuid}), e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }

    @GET
    @Path(value="ontology")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed list() throws ArtificerAtomException {
        try {
            List ontologies = this.ontologyService.get();
            Feed feed = new Feed();
            feed.setTitle("S-RAMP Ontology Feed");
            feed.setUpdated(new Date());
            for (ArtificerOntology ontology : ontologies) {
                Entry entry = ArtificerAtomUtils.wrapOntology((ArtificerOntology)ontology, null);
                Source source = new Source();
                source.setBase(new URI(ontology.getBase()));
                source.setId(new URI(ontology.getId()));
                entry.setSource(source);
                feed.getEntries().add(entry);
            }
            return feed;
        }
        catch (Exception e) {
            OntologyResource.logError(logger, Messages.i18n.format("ERROR_GETTING_ONTOLOGIES", new Object[0]), e);
            throw new ArtificerAtomException((Throwable)e);
        }
    }
}

