/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.services;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.artificer.atom.err.ArtificerAtomException;
import org.artificer.atom.visitors.ArtifactToSummaryAtomEntryVisitor;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.MediaType;
import org.artificer.common.visitors.ArtifactVisitor;
import org.artificer.common.visitors.ArtifactVisitorHelper;
import org.artificer.server.QueryServiceImpl;
import org.artificer.server.atom.services.AbstractResource;
import org.artificer.server.core.api.PagedResult;
import org.artificer.server.i18n.Messages;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Link;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeedResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(AbstractFeedResource.class);
    protected final QueryServiceImpl queryService = new QueryServiceImpl();

    protected Feed createArtifactFeed(String query, Integer startPage, Integer startIndex, Integer count, String orderBy, Boolean ascending, Set<String> propNames, String baseUrl) throws ArtificerAtomException {
        if (query == null) {
            throw new ArtificerAtomException(Messages.i18n.format("MISSING_QUERY_PARAM", new Object[0]));
        }
        try {
            PagedResult<BaseArtifactType> artifactSet = this.queryService.query(query, startPage, startIndex, count, orderBy, ascending);
            Feed feed = this.createFeed(artifactSet, propNames, baseUrl);
            this.addPaginationLinks(feed, artifactSet, baseUrl);
            return feed;
        }
        catch (Throwable e) {
            AbstractFeedResource.logError(logger, Messages.i18n.format("Error trying to create an Artifact Feed.", new Object[0]), e);
            throw new ArtificerAtomException(e);
        }
    }

    private Feed createFeed(PagedResult<BaseArtifactType> pagedResult, Set<String> propNames, String baseUrl) throws Exception {
        Feed feed = new Feed();
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_PROVIDER_QNAME, "Artificer");
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_ITEMS_PER_PAGE_QNAME, String.valueOf(pagedResult.getPageSize()));
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_START_INDEX_QNAME, String.valueOf(pagedResult.getStartIndex()));
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_TOTAL_RESULTS_QNAME, String.valueOf(pagedResult.getTotalSize()));
        feed.setId(new URI("urn:uuid:" + UUID.randomUUID().toString()));
        feed.setTitle("S-RAMP Feed");
        feed.setSubtitle("Ad Hoc query feed");
        feed.setUpdated(new Date());
        feed.getAuthors().add(new Person("anonymous"));
        ArtifactToSummaryAtomEntryVisitor visitor = new ArtifactToSummaryAtomEntryVisitor(baseUrl, propNames);
        for (BaseArtifactType artifact : pagedResult.getResults()) {
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            Entry entry = visitor.getAtomEntry();
            feed.getEntries().add(entry);
            visitor.reset();
        }
        return feed;
    }

    private void addPaginationLinks(Feed feed, PagedResult<BaseArtifactType> pagedResult, String baseUrl) throws UnsupportedEncodingException {
        int pageSize = pagedResult.getPageSize();
        int startIndex = pagedResult.getStartIndex();
        String orderBy = pagedResult.getOrderBy();
        boolean ascending = pagedResult.isAscending();
        String hrefPattern = "%1$s?query=%2$s&startIndex=%3$s&pageSize=%4$s&orderBy=%5$s&ascending=%6$s";
        String encodedQuery = URLEncoder.encode(pagedResult.getQuery(), "UTF-8");
        String firstHref = String.format(hrefPattern, baseUrl, encodedQuery, 0, String.valueOf(pageSize), String.valueOf(orderBy), String.valueOf(ascending));
        int prevIndex = Math.max(0, startIndex - pageSize);
        String prevHref = String.format(hrefPattern, baseUrl, encodedQuery, prevIndex, String.valueOf(pageSize), String.valueOf(orderBy), String.valueOf(ascending));
        String nextHref = String.format(hrefPattern, baseUrl, encodedQuery, startIndex + pageSize, String.valueOf(pageSize), String.valueOf(orderBy), String.valueOf(ascending));
        Link first = new Link("first", firstHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        Link prev = new Link("prev", prevHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        Link next = new Link("next", nextHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        if (startIndex > 0) {
            feed.getLinks().add(first);
            feed.getLinks().add(prev);
        }
        if (startIndex + pageSize < pagedResult.getTotalSize()) {
            feed.getLinks().add(next);
        }
    }
}

