/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import org.apache.commons.lang.StringUtils;
import org.artificer.repository.AuditManager;
import org.artificer.repository.AuditManagerFactory;
import org.artificer.repository.PersistenceFactory;
import org.artificer.repository.PersistenceManager;
import org.artificer.repository.QueryManager;
import org.artificer.repository.QueryManagerFactory;
import org.artificer.server.core.api.AbstractService;

public abstract class AbstractServiceImpl
implements AbstractService {
    private String username;
    private String password;

    public void login(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected PersistenceManager persistenceManager() {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            persistenceManager.login(this.username, this.password);
        }
        return persistenceManager;
    }

    protected AuditManager auditManager() {
        AuditManager auditManager = AuditManagerFactory.newInstance();
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            auditManager.login(this.username, this.password);
        }
        return auditManager;
    }

    protected QueryManager queryManager() {
        QueryManager queryManager = QueryManagerFactory.newInstance();
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            queryManager.login(this.username, this.password);
        }
        return queryManager;
    }

    public int startIndex(Integer startPage, Integer startIndex, Integer count) {
        if (startIndex == null && startPage != null) {
            int c = count != null ? count : 100;
            startIndex = (startPage - 1) * c;
        }
        if (startIndex == null) {
            startIndex = 0;
        }
        return startIndex;
    }
}

