/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.artificer.common.ArtificerException;
import org.artificer.common.error.ArtificerUserException;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.common.query.xpath.XPathParser;
import org.artificer.common.query.xpath.ast.Query;
import org.artificer.repository.i18n.Messages;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.ArtificerQueryArgs;
import org.artificer.repository.query.NumberReplacementParam;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.query.QueryReplacementParam;
import org.artificer.repository.query.StringReplacementParam;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractArtificerQueryImpl
implements ArtificerQuery {
    private static final XPathParser sParser = new XPathParser();
    protected String xpathTemplate;
    protected ArtificerQueryArgs args;
    private List<QueryReplacementParam<?>> replacementParams = new ArrayList();

    public AbstractArtificerQueryImpl(String xpathTemplate, ArtificerQueryArgs args) {
        this.xpathTemplate = xpathTemplate;
        this.args = args;
    }

    @Override
    public void setString(String paramValue) {
        this.replacementParams.add(new StringReplacementParam(paramValue));
    }

    @Override
    public void setDate(Date date) {
        String val = ISODateTimeFormat.date().print((ReadableInstant)new DateTime((Object)date));
        this.replacementParams.add(new StringReplacementParam(val));
    }

    @Override
    public void setDateTime(Calendar date) {
        String val = ISODateTimeFormat.dateTimeNoMillis().print((ReadableInstant)new DateTime((Object)date));
        this.replacementParams.add(new StringReplacementParam(val));
    }

    @Override
    public void setNumber(int paramValue) {
        this.replacementParams.add(new NumberReplacementParam(paramValue));
    }

    @Override
    public void setNumber(long paramValue) {
        this.replacementParams.add(new NumberReplacementParam(paramValue));
    }

    @Override
    public void setNumber(float paramValue) {
        this.replacementParams.add(new NumberReplacementParam(Float.valueOf(paramValue)));
    }

    @Override
    public void setNumber(double paramValue) {
        this.replacementParams.add(new NumberReplacementParam(paramValue));
    }

    @Override
    public void setNumber(BigInteger paramValue) {
        this.replacementParams.add(new NumberReplacementParam(paramValue));
    }

    @Override
    public final PagedResult<ArtifactSummary> executeQuery() throws ArtificerException {
        String xpath = AbstractArtificerQueryImpl.formatQuery(this.xpathTemplate, this.replacementParams);
        Query queryModel = AbstractArtificerQueryImpl.parseXPath(xpath);
        this.validateQuery(queryModel);
        return this.executeQuery(queryModel);
    }

    public static final String formatQuery(String xpathTemplate, List<QueryReplacementParam<?>> replacementParams) throws ArtificerUserException {
        StringBuilder builder = new StringBuilder();
        String[] xpathSegments = xpathTemplate.split("\\?");
        int paramCounter = 0;
        for (String segment : xpathSegments) {
            boolean isLastSegment;
            builder.append(segment);
            boolean bl = isLastSegment = segment == xpathSegments[xpathSegments.length - 1];
            if (isLastSegment) continue;
            if (paramCounter >= replacementParams.size()) {
                throw new ArtificerUserException(Messages.i18n.format("TOO_FEW_QUERY_PARAMS", new Object[0]));
            }
            QueryReplacementParam<?> param = replacementParams.get(paramCounter);
            builder.append(param.getFormattedValue());
            ++paramCounter;
        }
        if (replacementParams.size() > paramCounter) {
            throw new ArtificerUserException(Messages.i18n.format("TOO_MANY_QUERY_PARAMS", new Object[0]));
        }
        return builder.toString();
    }

    protected static final Query parseXPath(String xpath) throws ArtificerUserException {
        try {
            return sParser.parseXPath(xpath);
        }
        catch (Throwable e) {
            throw new ArtificerUserException(Messages.i18n.format("QUERY_PARSE_FAILED", new Object[0]), e);
        }
    }

    protected void validateQuery(Query queryModel) throws ArtificerUserException {
    }

    protected abstract PagedResult<ArtifactSummary> executeQuery(Query var1) throws ArtificerException;
}

