/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common.ontology;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArtificerOntology
implements Serializable {
    private String uuid;
    private String label;
    private String comment;
    private String base;
    private String id;
    private String createdBy;
    private Date createdOn;
    private String lastModifiedBy;
    private Date lastModifiedOn;
    private List<ArtificerOntologyClass> rootClasses = new ArrayList<ArtificerOntologyClass>();
    private Map<URI, ArtificerOntologyClass> classIndexByUri = new HashMap<URI, ArtificerOntologyClass>();
    private Map<String, ArtificerOntologyClass> classIndexById = new HashMap<String, ArtificerOntologyClass>();

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ArtificerOntologyClass> getRootClasses() {
        return this.rootClasses;
    }

    public List<ArtificerOntologyClass> getAllClasses() {
        ArrayList<ArtificerOntologyClass> allClasses = new ArrayList<ArtificerOntologyClass>();
        this.addAllClasses(allClasses, this.getRootClasses());
        return allClasses;
    }

    private void addAllClasses(List<ArtificerOntologyClass> allClasses, List<ArtificerOntologyClass> classes) {
        allClasses.addAll(classes);
        for (ArtificerOntologyClass c : classes) {
            this.addAllClasses(allClasses, c.getChildren());
        }
    }

    public void setRootClasses(List<ArtificerOntologyClass> rootClasses) {
        this.rootClasses = rootClasses;
    }

    public ArtificerOntologyClass createClass(String id) {
        ArtificerOntologyClass c = new ArtificerOntologyClass();
        c.setId(id);
        String uri = this.getBase() + "#" + id;
        try {
            c.setUri(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return c;
    }

    public synchronized ArtificerOntologyClass findClass(String id) {
        ArtificerOntologyClass candidate;
        if (this.classIndexById.containsKey(id)) {
            return this.classIndexById.get(id);
        }
        ArtificerOntologyClass found = null;
        Iterator<ArtificerOntologyClass> i$ = this.rootClasses.iterator();
        while (i$.hasNext() && (found = (candidate = i$.next()).findClass(id)) == null) {
        }
        if (found != null) {
            this.classIndexById.put(id, found);
        }
        return found;
    }

    public synchronized ArtificerOntologyClass findClass(URI uri) {
        ArtificerOntologyClass candidate;
        if (this.classIndexByUri.containsKey(uri)) {
            return this.classIndexByUri.get(uri);
        }
        ArtificerOntologyClass found = null;
        Iterator<ArtificerOntologyClass> i$ = this.rootClasses.iterator();
        while (i$.hasNext() && (found = (candidate = i$.next()).findClass(uri)) == null) {
        }
        if (found != null) {
            this.classIndexByUri.put(uri, found);
        }
        return found;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public static class ArtificerOntologyClass
    implements Serializable {
        private String id;
        private String label;
        private String comment;
        private URI uri;
        @JsonIgnore
        private ArtificerOntologyClass parent;
        private List<ArtificerOntologyClass> children = new ArrayList<ArtificerOntologyClass>();

        public ArtificerOntologyClass findClass(String id) {
            if (this.id.equals(id)) {
                return this;
            }
            for (ArtificerOntologyClass c : this.children) {
                ArtificerOntologyClass found = c.findClass(id);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public ArtificerOntologyClass findClass(URI uri) {
            if (this.uri.equals(uri)) {
                return this;
            }
            for (ArtificerOntologyClass c : this.children) {
                ArtificerOntologyClass found = c.findClass(uri);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public ArtificerOntologyClass getParent() {
            return this.parent;
        }

        public void setParent(ArtificerOntologyClass parent) {
            this.parent = parent;
        }

        public List<ArtificerOntologyClass> getChildren() {
            return this.children;
        }

        public void setChildren(List<ArtificerOntologyClass> children) {
            this.children = children;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public Set<URI> normalize() {
            HashSet<URI> uris = new HashSet<URI>();
            for (ArtificerOntologyClass current = this; current != null; current = current.getParent()) {
                uris.add(current.getUri());
            }
            return uris;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

