/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common.maven;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.maven.MavenGavInfo;

public class MavenUtil {
    public static String gavQuery(MavenGavInfo gavInfo) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("/s-ramp");
        ArrayList<String> criteria = new ArrayList<String>();
        criteria.add("@maven.groupId = '" + gavInfo.getGroupId() + "'");
        criteria.add("@maven.artifactId = '" + gavInfo.getArtifactId() + "'");
        criteria.add("@maven.version = '" + gavInfo.getVersion() + "'");
        if (StringUtils.isNotBlank((String)gavInfo.getType())) {
            criteria.add("@maven.type = '" + gavInfo.getType() + "'");
        }
        if (StringUtils.isNotBlank((String)gavInfo.getClassifier())) {
            criteria.add("@maven.classifier = '" + gavInfo.getClassifier() + "'");
        }
        if (StringUtils.isNotBlank((String)gavInfo.getSnapshotId())) {
            criteria.add("@maven.snapshot.id = '" + gavInfo.getSnapshotId() + "'");
        }
        if (criteria.size() > 0) {
            queryBuilder.append("[");
            queryBuilder.append(StringUtils.join(criteria, (String)" and "));
            queryBuilder.append("]");
        }
        return queryBuilder.toString();
    }
}

