/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common.error;

import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.common.i18n.Messages;

public class ArtificerUserException
extends ArtificerServerException {
    private static final long serialVersionUID = -1974585440431377826L;

    public ArtificerUserException() {
    }

    public ArtificerUserException(String message) {
        super(message);
    }

    public ArtificerUserException(String message, Throwable cause) {
        super(message, cause);
    }

    public ArtificerUserException(String msg, String stackTrace) {
        super(msg, stackTrace);
    }

    public ArtificerUserException(Throwable cause) {
        super(cause);
    }

    public static ArtificerUserException invalidClassifiedBy(String classifiedBy) {
        return new ArtificerUserException(Messages.i18n.format("INVALID_CLASSIFIED_BY", classifiedBy));
    }

    public static ArtificerUserException derivedArtifactCreate(ArtifactTypeEnum artifactType) {
        return new ArtificerUserException(Messages.i18n.format("CANNOT_CREATE_DERIVED_ARTY", new Object[]{artifactType}));
    }

    public static ArtificerUserException filenameRequired() {
        return new ArtificerUserException(Messages.i18n.format("FILENAME_REQUIRED", new Object[0]));
    }

    public static ArtificerUserException derivedArtifactDelete(ArtifactTypeEnum artifactType) {
        return new ArtificerUserException(Messages.i18n.format("CANNOT_DELETE_DERIVED_ARTY", new Object[]{artifactType}));
    }

    public static ArtificerUserException auditEntryNotFound(String artifactUuid, String auditEntryUuid) {
        return new ArtificerUserException(Messages.i18n.format("AUDIT_ENTRY_NOT_FOUND", artifactUuid, auditEntryUuid));
    }
}

