/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common.error;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.artificer.common.ArtificerException;

public class ArtificerServerException
extends ArtificerException {
    private static final long serialVersionUID = 2648287148198104189L;
    private static final Pattern ST_PATTERN = Pattern.compile("([a-zA-Z0-9_\\.]*)\\.([a-zA-Z0-9_\\.]*)\\(([a-zA-Z0-9_\\.]*):([\\d]*)\\)");

    public ArtificerServerException() {
    }

    public ArtificerServerException(String message) {
        super(message);
    }

    public ArtificerServerException(String message, Throwable cause) {
        super(message, cause);
    }

    public ArtificerServerException(Throwable cause) {
        super(cause);
    }

    public ArtificerServerException(String msg, String stackTrace) {
        super(msg);
        this.setStackTrace(ArtificerServerException.parseStackTrace(stackTrace));
    }

    private static StackTraceElement[] parseStackTrace(String stackTrace) {
        ArrayList<StackTraceElement> stElements = new ArrayList<StackTraceElement>();
        Matcher matcher = ST_PATTERN.matcher(stackTrace);
        while (matcher.find()) {
            String className = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int lineNumber = Integer.parseInt(matcher.group(4) == null ? "0" : matcher.group(4));
            stElements.add(new StackTraceElement(className, methodName, fileName, lineNumber));
        }
        return stElements.toArray(new StackTraceElement[stElements.size()]);
    }
}

