/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class Version {
    private static final Version instance = new Version();
    private String versionString;
    private String versionDate;

    public static final Version get() {
        return instance;
    }

    private Version() {
        this.load();
    }

    private void load() {
        URL url = Version.class.getResource("version.properties");
        if (url == null) {
            this.versionString = "Unknown";
            this.versionDate = new Date().toString();
        } else {
            InputStream is = null;
            Properties props = new Properties();
            try {
                is = url.openStream();
                props.load(is);
                this.versionString = props.getProperty("version", "Unknown");
                this.versionDate = props.getProperty("date", new Date().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getVersionDate() {
        return this.versionDate;
    }
}

