/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.artificer.common.ArtifactType;
import org.artificer.common.error.ArtificerConflictException;
import org.artificer.common.error.ArtificerWrongModelException;
import org.artificer.common.visitors.HierarchicalArtifactVisitor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Actor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ActorEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ActorTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Artifact;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.AttributeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFaultEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFaultTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInputEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutputEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Choreography;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ChoreographyProcess;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ClassificationData;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Collaboration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.CollaborationProcess;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Composition;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Effect;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EffectEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EffectTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Element;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclarationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclarationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Error;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ErrorResponse;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Event;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EventEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EventTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtensionType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Fault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.FaultEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.FaultTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.InformationType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.InformationTypeEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.InformationTypeTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.MessageEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.MessageTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.NamedWsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ObjectFactory;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInputEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutputEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Orchestration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationProcess;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationProcessEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationProcessTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Organization;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PartEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PartTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Policy;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyAttachment;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyExpression;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyExpressionEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyExpressionTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicySubject;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicySubjectEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicySubjectTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTypeEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTypeTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Process;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PropertyData;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.RelationshipData;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.RelationshipTypeData;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceComposition;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContract;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContractEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContractTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEndpoint;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstance;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstanceEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstanceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterface;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterfaceEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterfaceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoaModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapAddress;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapBinding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQueryData;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.System;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Task;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.TaskEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.TaskTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocumentEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocumentTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlExtension;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlExtensionEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlExtensionTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocumentEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocumentTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdTypeEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdTypeTarget;
import org.reflections.ReflectionUtils;

public class ArtifactVerifier
extends HierarchicalArtifactVisitor {
    private static final Set<String> reservedNames;
    private final ArtifactType artifactType;
    private BaseArtifactType oldArtifact = null;

    public ArtifactVerifier(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }

    public ArtifactVerifier(BaseArtifactType oldArtifact, ArtifactType artifactType) {
        this(artifactType);
        this.oldArtifact = oldArtifact;
    }

    @Override
    protected void visitBase(BaseArtifactType artifact) {
        super.visitBase(artifact);
        this.verifyModel(artifact);
        this.verifyNames(artifact);
    }

    @Override
    public void visit(XsdDocument artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("importedXsds", artifact.getImportedXsds());
            this.verifyEmptyDerivedRelationships("includedXsds", artifact.getIncludedXsds());
            this.verifyEmptyDerivedRelationships("redefinedXsds", artifact.getRedefinedXsds());
        } else {
            XsdDocument castOld = (XsdDocument)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("importedXsds", artifact.getImportedXsds(), castOld.getImportedXsds());
            this.verifyUnchangedDerivedRelationships("includedXsds", artifact.getIncludedXsds(), castOld.getIncludedXsds());
            this.verifyUnchangedDerivedRelationships("redefinedXsds", artifact.getRedefinedXsds(), castOld.getRedefinedXsds());
        }
    }

    @Override
    public void visit(WsdlDocument artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("importedXsds", artifact.getImportedXsds());
            this.verifyEmptyDerivedRelationships("includedXsds", artifact.getIncludedXsds());
            this.verifyEmptyDerivedRelationships("redefinedXsds", artifact.getRedefinedXsds());
            this.verifyEmptyDerivedRelationships("importedWsdls", artifact.getImportedWsdls());
        } else {
            WsdlDocument castOld = (WsdlDocument)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("importedXsds", artifact.getImportedXsds(), castOld.getImportedXsds());
            this.verifyUnchangedDerivedRelationships("includedXsds", artifact.getIncludedXsds(), castOld.getIncludedXsds());
            this.verifyUnchangedDerivedRelationships("redefinedXsds", artifact.getRedefinedXsds(), castOld.getRedefinedXsds());
            this.verifyUnchangedDerivedRelationships("importedWsdls", artifact.getImportedWsdls(), castOld.getImportedWsdls());
        }
    }

    @Override
    public void visit(Message artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("part", artifact.getPart());
        } else {
            Message castOld = (Message)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("part", artifact.getPart(), castOld.getPart());
        }
    }

    @Override
    public void visit(Part artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("element", artifact.getElement());
            this.verifyEmptyDerivedRelationships("type", artifact.getType());
        } else {
            Part castOld = (Part)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("element", artifact.getElement(), castOld.getElement());
            this.verifyUnchangedDerivedRelationships("type", artifact.getType(), castOld.getType());
        }
    }

    @Override
    public void visit(PortType artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("operation", artifact.getOperation());
        } else {
            PortType castOld = (PortType)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("operation", artifact.getOperation(), castOld.getOperation());
        }
    }

    @Override
    public void visit(Operation artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("input", artifact.getInput());
            this.verifyEmptyDerivedRelationships("output", artifact.getOutput());
            this.verifyEmptyDerivedRelationships("fault", artifact.getFault());
        } else {
            Operation castOld = (Operation)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("input", artifact.getInput(), castOld.getInput());
            this.verifyUnchangedDerivedRelationships("output", artifact.getOutput(), castOld.getOutput());
            this.verifyUnchangedDerivedRelationships("fault", artifact.getFault(), castOld.getFault());
        }
    }

    @Override
    public void visit(OperationInput artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("message", artifact.getMessage());
        } else {
            OperationInput castOld = (OperationInput)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("message", artifact.getMessage(), castOld.getMessage());
        }
    }

    @Override
    public void visit(OperationOutput artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("message", artifact.getMessage());
        } else {
            OperationOutput castOld = (OperationOutput)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("message", artifact.getMessage(), castOld.getMessage());
        }
    }

    @Override
    public void visit(Fault artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("message", artifact.getMessage());
        } else {
            Fault castOld = (Fault)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("message", artifact.getMessage(), castOld.getMessage());
        }
    }

    @Override
    public void visit(Binding artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("bindingOperation", artifact.getBindingOperation());
            this.verifyEmptyDerivedRelationships("portType", artifact.getPortType());
        } else {
            Binding castOld = (Binding)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("bindingOperation", artifact.getBindingOperation(), castOld.getBindingOperation());
            this.verifyUnchangedDerivedRelationships("portType", artifact.getPortType(), castOld.getPortType());
        }
    }

    @Override
    public void visit(BindingOperation artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("input", artifact.getInput());
            this.verifyEmptyDerivedRelationships("output", artifact.getOutput());
            this.verifyEmptyDerivedRelationships("fault", artifact.getFault());
            this.verifyEmptyDerivedRelationships("operation", artifact.getOperation());
        } else {
            BindingOperation castOld = (BindingOperation)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("input", artifact.getInput(), castOld.getInput());
            this.verifyUnchangedDerivedRelationships("output", artifact.getOutput(), castOld.getOutput());
            this.verifyUnchangedDerivedRelationships("fault", artifact.getFault(), castOld.getFault());
            this.verifyUnchangedDerivedRelationships("operation", artifact.getOperation(), castOld.getOperation());
        }
    }

    @Override
    public void visit(WsdlService artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("port", artifact.getPort());
        } else {
            WsdlService castOld = (WsdlService)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("port", artifact.getPort(), castOld.getPort());
        }
    }

    @Override
    public void visit(Port artifact) {
        super.visit(artifact);
        if (this.oldArtifact == null) {
            this.verifyEmptyDerivedRelationships("binding", artifact.getBinding());
        } else {
            Port castOld = (Port)this.oldArtifact;
            this.verifyUnchangedDerivedRelationships("binding", artifact.getBinding(), castOld.getBinding());
        }
    }

    private void verifyModel(BaseArtifactType artifact) {
        if (!this.artifactType.getArtifactType().getApiType().equals((Object)artifact.getArtifactType())) {
            this.error = new ArtificerWrongModelException(this.artifactType.getArtifactType().getApiType().value(), artifact.getArtifactType().value());
        }
    }

    private void verifyNames(BaseArtifactType artifact) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        ArrayList<String> relationshipNames = new ArrayList<String>();
        for (Property property : artifact.getProperty()) {
            propertyNames.add(property.getPropertyName());
        }
        for (Relationship relationship : artifact.getRelationship()) {
            relationshipNames.add(relationship.getRelationshipType());
        }
        for (String propertyName : propertyNames) {
            if (this.isReserved(propertyName)) {
                this.error = ArtificerConflictException.reservedName(propertyName);
            }
            if (relationshipNames.contains(propertyName)) {
                this.error = ArtificerConflictException.duplicateName(propertyName);
            }
            if (Collections.frequency(propertyNames, propertyName) <= 1) continue;
            this.error = ArtificerConflictException.duplicateName(propertyName);
        }
        for (String relationshipName : relationshipNames) {
            if (this.isReserved(relationshipName)) {
                this.error = ArtificerConflictException.reservedName(relationshipName);
            }
            if (!propertyNames.contains(relationshipName)) continue;
            this.error = ArtificerConflictException.duplicateName(relationshipName);
        }
    }

    private boolean isReserved(String s) {
        return reservedNames.contains(s.toLowerCase());
    }

    private void verifyEmptyDerivedRelationships(String relationshipType, Collection<?> relationships) {
        if (!relationships.isEmpty()) {
            this.error = ArtificerConflictException.derivedRelationshipCreation(relationshipType);
        }
    }

    private void verifyEmptyDerivedRelationships(String relationshipType, Object relationship) {
        if (relationship != null) {
            this.error = ArtificerConflictException.derivedRelationshipCreation(relationshipType);
        }
    }

    private void verifyUnchangedDerivedRelationships(String relationshipType, Collection<?> relationships, Collection<?> oldRelationships) {
        if (relationships.size() != oldRelationships.size()) {
            this.error = ArtificerConflictException.derivedRelationshipCreation(relationshipType);
        }
    }

    private void verifyUnchangedDerivedRelationships(String relationshipType, Object relationship, Object oldRelationship) {
        if (oldRelationship != null && relationship == null || oldRelationship == null && relationship != null) {
            this.error = ArtificerConflictException.derivedRelationshipCreation(relationshipType);
        }
    }

    static {
        Class[] classes;
        reservedNames = new HashSet<String>();
        for (Class clazz : classes = new Class[]{Actor.class, ActorEnum.class, ActorTarget.class, Artifact.class, AttributeDeclaration.class, BaseArtifactEnum.class, BaseArtifactTarget.class, BaseArtifactType.class, Binding.class, BindingEnum.class, BindingOperation.class, BindingOperationEnum.class, BindingOperationFault.class, BindingOperationFaultEnum.class, BindingOperationFaultTarget.class, BindingOperationInput.class, BindingOperationInputEnum.class, BindingOperationInputTarget.class, BindingOperationOutput.class, BindingOperationOutputEnum.class, BindingOperationOutputTarget.class, BindingOperationTarget.class, BindingTarget.class, Choreography.class, ChoreographyProcess.class, ClassificationData.class, Collaboration.class, CollaborationProcess.class, ComplexTypeDeclaration.class, Composition.class, DerivedArtifactEnum.class, DerivedArtifactTarget.class, DerivedArtifactType.class, Document.class, DocumentArtifactEnum.class, DocumentArtifactTarget.class, DocumentArtifactType.class, Effect.class, EffectEnum.class, EffectTarget.class, Element.class, ElementDeclaration.class, ElementDeclarationEnum.class, ElementDeclarationTarget.class, ElementEnum.class, ElementTarget.class, Error.class, ErrorResponse.class, Event.class, EventEnum.class, EventTarget.class, ExtendedArtifactType.class, ExtendedDocument.class, ExtensionType.class, Fault.class, FaultEnum.class, FaultTarget.class, InformationType.class, InformationTypeEnum.class, InformationTypeTarget.class, Message.class, MessageEnum.class, MessageTarget.class, NamedWsdlDerivedArtifactType.class, ObjectFactory.class, Operation.class, OperationEnum.class, OperationInput.class, OperationInputEnum.class, OperationInputTarget.class, OperationOutput.class, OperationOutputEnum.class, OperationOutputTarget.class, OperationTarget.class, Orchestration.class, OrchestrationEnum.class, OrchestrationProcess.class, OrchestrationProcessEnum.class, OrchestrationProcessTarget.class, OrchestrationTarget.class, Organization.class, Part.class, PartEnum.class, PartTarget.class, Policy.class, PolicyAttachment.class, PolicyDocument.class, PolicyEnum.class, PolicyExpression.class, PolicyExpressionEnum.class, PolicyExpressionTarget.class, PolicySubject.class, PolicySubjectEnum.class, PolicySubjectTarget.class, PolicyTarget.class, Port.class, PortEnum.class, PortTarget.class, PortType.class, PortTypeEnum.class, PortTypeTarget.class, Process.class, Property.class, PropertyData.class, Relationship.class, RelationshipData.class, RelationshipTypeData.class, Service.class, ServiceComposition.class, ServiceContract.class, ServiceContractEnum.class, ServiceContractTarget.class, ServiceEndpoint.class, ServiceEnum.class, ServiceImplementationModelEnum.class, ServiceImplementationModelTarget.class, ServiceImplementationModelType.class, ServiceInstance.class, ServiceInstanceEnum.class, ServiceInstanceTarget.class, ServiceInterface.class, ServiceInterfaceEnum.class, ServiceInterfaceTarget.class, ServiceOperation.class, ServiceOperationEnum.class, ServiceOperationTarget.class, ServiceTarget.class, SimpleTypeDeclaration.class, SoaModelType.class, SoapAddress.class, SoapBinding.class, StoredQuery.class, StoredQueryData.class, System.class, Target.class, Task.class, TaskEnum.class, TaskTarget.class, WsdlDerivedArtifactType.class, WsdlDocument.class, WsdlDocumentEnum.class, WsdlDocumentTarget.class, WsdlExtension.class, WsdlExtensionEnum.class, WsdlExtensionTarget.class, WsdlService.class, XmlDocument.class, XsdDocument.class, XsdDocumentEnum.class, XsdDocumentTarget.class, XsdType.class, XsdTypeEnum.class, XsdTypeTarget.class}) {
            Set fields = ReflectionUtils.getAllFields((Class)clazz, (Predicate[])new Predicate[0]);
            for (Field field : fields) {
                reservedNames.add(field.getName().toLowerCase());
            }
        }
    }
}

