/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ArtifactContent {
    private final String path;
    private final String filename;
    private File tempFile = null;
    private List<InputStream> tempStreams = new ArrayList<InputStream>();

    public ArtifactContent(String path, InputStream is) throws IOException {
        if (path != null) {
            if (path.startsWith(File.separatorChar + "")) {
                path = path.replaceFirst(File.separatorChar + "", "");
            }
            this.path = path;
            int index = path.lastIndexOf(File.separatorChar);
            this.filename = path.substring(index + 1);
        } else {
            this.path = null;
            this.filename = null;
        }
        FileOutputStream os = null;
        try {
            this.tempFile = File.createTempFile(UUID.randomUUID().toString(), this.filename);
            os = FileUtils.openOutputStream((File)this.tempFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            try {
                if (this.tempFile != null) {
                    FileUtils.deleteQuietly((File)this.tempFile);
                }
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    public ArtifactContent(String fullPath, File file) throws IOException {
        this(fullPath, new FileInputStream(file));
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.tempFile != null) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.tempFile));
            this.tempStreams.add(is);
            return is;
        }
        return null;
    }

    public File getFile() {
        return this.tempFile;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPath() {
        return this.path;
    }

    public void cleanup() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        for (InputStream is : this.tempStreams) {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

