/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.artificer.common;

/**
 * Base class for all S-RAMP related exceptions.
 *
 * @author eric.wittmann@redhat.com
 */
public abstract class ArtificerException extends Exception {

    private static final long serialVersionUID = -7300488926930529656L;

    /**
     * Constructor.
     */
    public ArtificerException() {
    }

    /**
     * Constructor.
     * @param message
     */
    public ArtificerException(String message) {
        super(message);
    }

    /**
     * Constructor.
     * @param message
     * @param cause
     */
    public ArtificerException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     * @param cause
     */
    public ArtificerException(Throwable cause) {
        super(cause);
    }

}
