/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.client;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.ArtificerClientException;
import org.artificer.client.i18n.Messages;
import org.artificer.client.query.QueryResultSet;
import org.artificer.common.error.ArtificerServerException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class ArtificerClientQuery {
    private ArtificerAtomApiClient client;
    private String queryTemplate;
    private List<String> replacementParams = new ArrayList<String>();
    private int startIndex = 0;
    private int count = 20;
    private String orderBy = "name";
    private boolean ascending = true;
    private Set<String> propertyNames = new HashSet<String>();

    protected ArtificerClientQuery(ArtificerAtomApiClient client, String queryTemplate) {
        this.client = client;
        this.queryTemplate = queryTemplate;
    }

    public ArtificerClientQuery parameter(String param) {
        this.replacementParams.add("'" + param.replace("'", "''") + "'");
        return this;
    }

    public ArtificerClientQuery parameter(int param) {
        this.replacementParams.add(String.valueOf(param));
        return this;
    }

    public ArtificerClientQuery parameter(long param) {
        this.replacementParams.add(String.valueOf(param));
        return this;
    }

    public ArtificerClientQuery parameter(double param) {
        this.replacementParams.add(String.valueOf(param));
        return this;
    }

    public ArtificerClientQuery parameter(Date param) {
        String val = ISODateTimeFormat.date().print((ReadableInstant)new DateTime((Object)param));
        this.replacementParams.add("'" + val + "'");
        return this;
    }

    public ArtificerClientQuery parameter(Calendar param) {
        String val = ISODateTimeFormat.dateTimeNoMillis().print((ReadableInstant)new DateTime((Object)param));
        this.replacementParams.add("'" + val + "'");
        return this;
    }

    public ArtificerClientQuery parameter(float param) {
        this.replacementParams.add(String.valueOf(param));
        return this;
    }

    public ArtificerClientQuery parameter(Number param) {
        this.replacementParams.add(param.toString());
        return this;
    }

    public ArtificerClientQuery startIndex(int startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public ArtificerClientQuery count(int count) {
        this.count = count;
        return this;
    }

    public ArtificerClientQuery orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public ArtificerClientQuery ascending() {
        this.ascending = true;
        return this;
    }

    public ArtificerClientQuery descending() {
        this.ascending = false;
        return this;
    }

    public ArtificerClientQuery propertyName(String propertyName) {
        this.propertyNames.add(propertyName);
        return this;
    }

    public QueryResultSet query() throws ArtificerClientException, ArtificerServerException {
        String query = this.formatQuery();
        return this.client.query(query, this.startIndex, this.count, this.orderBy, this.ascending, this.propertyNames);
    }

    private String formatQuery() throws ArtificerClientException {
        StringBuilder builder = new StringBuilder();
        String[] xpathSegments = this.queryTemplate.split("\\?");
        int paramCounter = 0;
        for (String segment : xpathSegments) {
            boolean isLastSegment;
            builder.append(segment);
            boolean bl = isLastSegment = segment == xpathSegments[xpathSegments.length - 1];
            if (isLastSegment) continue;
            if (paramCounter >= this.replacementParams.size()) {
                throw new ArtificerClientException(Messages.i18n.format("TOO_FEW_QUERY_PARAMS", new Object[0]));
            }
            String param = this.replacementParams.get(paramCounter);
            builder.append(param);
            ++paramCounter;
        }
        if (this.replacementParams.size() > paramCounter) {
            throw new ArtificerClientException(Messages.i18n.format("TOO_MANY_QUERY_PARAMS", new Object[0]));
        }
        return builder.toString();
    }
}

