/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.osgi.remote.processor.service;

import aQute.bnd.osgi.Jar;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.arquillian.container.osgi.remote.processor.service.ImportPackageManager;
import org.arquillian.container.osgi.remote.processor.service.ManifestManager;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ImportPackageManagerImpl
implements ImportPackageManager {
    private static final String IMPORT_PACKAGE = "Import-Package";
    @Inject
    private Instance<ManifestManager> _manifestManagerInstance;

    @Override
    public Manifest cleanRepeatedImports(Manifest manifest, Collection<Archive<?>> auxiliaryArchives) throws IOException {
        List<String> auxiliaryArchivesPackages = this.getAuxiliaryArchivesPackages(auxiliaryArchives);
        Attributes mainAttributes = manifest.getMainAttributes();
        String importPackages = mainAttributes.getValue(IMPORT_PACKAGE);
        mainAttributes.remove(new Attributes.Name(IMPORT_PACKAGE));
        Map<String, Set<String>> importsWithDirectivesMap = this.toImportsWithDirectivesMap(importPackages);
        ArrayList<String> resultImports = new ArrayList<String>();
        for (String importValue : importsWithDirectivesMap.keySet()) {
            if (auxiliaryArchivesPackages.contains(importValue)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(importValue);
            for (String directive : importsWithDirectivesMap.get(importValue)) {
                sb.append(";");
                sb.append(directive);
            }
            resultImports.add(sb.toString());
        }
        ManifestManager manifestManager = (ManifestManager)this._manifestManagerInstance.get();
        manifest = manifestManager.putAttributeValue(manifest, IMPORT_PACKAGE, resultImports.toArray(new String[resultImports.size()]));
        return manifest;
    }

    private List<String> getAuxiliaryArchivesPackages(Collection<Archive<?>> auxiliaryArchives) throws IOException {
        ArrayList<String> packages = new ArrayList<String>();
        for (Archive<?> auxiliaryArchive : auxiliaryArchives) {
            ZipExporter zipExporter = (ZipExporter)auxiliaryArchive.as(ZipExporter.class);
            InputStream auxiliaryArchiveInputStream = zipExporter.exportAsInputStream();
            Jar jar = new Jar(auxiliaryArchive.getName(), auxiliaryArchiveInputStream);
            packages.addAll(jar.getPackages());
        }
        return packages;
    }

    private Map<String, Set<String>> toImportsWithDirectivesMap(String importsInManifest) {
        List<String> packageNamesWithDirectives = Arrays.asList(importsInManifest.split(","));
        HashMap<String, Set<String>> packagesNameToDirectives = new HashMap<String, Set<String>>();
        for (String packageNameWithDirectives : packageNamesWithDirectives) {
            LinkedList packageNameAndDirectives = new LinkedList();
            Collections.addAll(packageNameAndDirectives, packageNameWithDirectives.split(";"));
            String packageName = (String)packageNameAndDirectives.pop();
            HashSet currentDirectives = (HashSet)packagesNameToDirectives.get(packageName);
            if (currentDirectives == null) {
                currentDirectives = new HashSet();
            }
            currentDirectives.addAll(packageNameAndDirectives);
            packagesNameToDirectives.put(packageName, currentDirectives);
        }
        return packagesNameToDirectives;
    }
}

