/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.osgi.remote.processor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.arquillian.container.osgi.remote.activator.ArquillianBundleActivator;
import org.arquillian.container.osgi.remote.processor.service.BundleActivatorsManager;
import org.arquillian.container.osgi.remote.processor.service.ImportPackageManager;
import org.arquillian.container.osgi.remote.processor.service.ManifestManager;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.container.test.spi.client.deployment.AuxiliaryArchiveAppender;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiAllInProcessor
implements ApplicationArchiveProcessor {
    private static final String _ACTIVATORS_FILE = "/META-INF/services/" + BundleActivator.class.getCanonicalName();
    private static final String _REMOTE_LOADABLE_EXTENSION_FILE = "/META-INF/services/" + RemoteLoadableExtension.class.getCanonicalName();
    private static final Logger _logger = LoggerFactory.getLogger(ApplicationArchiveProcessor.class);
    @Inject
    private Instance<BundleActivatorsManager> _bundleActivatorsManagerInstance;
    @Inject
    private Instance<ImportPackageManager> _importPackageManagerInstance;
    @Inject
    private Instance<ManifestManager> _manifestManagerInstance;
    @Inject
    private Instance<ServiceLoader> _serviceLoaderInstance;

    public void process(Archive<?> archive, TestClass testClass) {
        try {
            JavaArchive javaArchive = (JavaArchive)archive;
            this.validateBundleArchive((Archive<?>)javaArchive);
            this.addTestClass(javaArchive, testClass);
            this.addOSGiImports(javaArchive);
            this.addArquillianDependencies(javaArchive);
            List<Archive<?>> auxiliaryArchives = this.loadAuxiliaryArchives();
            this.handleAuxiliaryArchives(javaArchive, auxiliaryArchives);
            this.cleanRepeatedImports(javaArchive, auxiliaryArchives);
            ManifestManager manifestManager = (ManifestManager)this._manifestManagerInstance.get();
            Manifest manifest = manifestManager.getManifest(javaArchive);
            Attributes mainAttributes = manifest.getMainAttributes();
            Attributes.Name bundleActivatorName = new Attributes.Name("Bundle-Activator");
            String bundleActivator = mainAttributes.getValue(bundleActivatorName);
            mainAttributes.put(bundleActivatorName, ArquillianBundleActivator.class.getCanonicalName());
            manifestManager.replaceManifest((Archive)javaArchive, manifest);
            javaArchive.addClass(ArquillianBundleActivator.class);
            if (bundleActivator != null) {
                this.addBundleActivator(javaArchive, bundleActivator);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid OSGi bundle: " + archive, ex);
        }
    }

    private void addArquillianDependencies(JavaArchive javaArchive) {
        javaArchive.addPackage(JMXTestRunner.class.getPackage());
    }

    private void addBundleActivator(JavaArchive javaArchive, String bundleActivatorValue) throws IOException {
        BundleActivatorsManager bundleActivatorsManager = (BundleActivatorsManager)this._bundleActivatorsManagerInstance.get();
        List<String> bundleActivators = bundleActivatorsManager.getBundleActivators((Archive)javaArchive, _ACTIVATORS_FILE);
        bundleActivators.add(bundleActivatorValue);
        bundleActivatorsManager.replaceBundleActivatorsFile((Archive)javaArchive, _ACTIVATORS_FILE, bundleActivators);
    }

    private void addOSGiImports(JavaArchive javaArchive) throws IOException {
        String[] extensionsImports = new String[]{"org.osgi.framework", "javax.management", "javax.management.*", "javax.naming", "javax.naming.*", "org.osgi.service.packageadmin", "org.osgi.service.startlevel", "org.osgi.util.tracker"};
        ManifestManager manifestManager = (ManifestManager)this._manifestManagerInstance.get();
        Manifest manifest = manifestManager.putAttributeValue(manifestManager.getManifest(javaArchive), "Import-Package", extensionsImports);
        manifestManager.replaceManifest((Archive)javaArchive, manifest);
    }

    private void addTestClass(JavaArchive javaArchive, TestClass testClass) throws IOException {
        Class<ClassContainer> classContainerClass = ClassContainer.class;
        if (!classContainerClass.isAssignableFrom(javaArchive.getClass())) {
            throw new IllegalArgumentException("ClassContainer expected: " + javaArchive);
        }
        Class javaClass = testClass.getJavaClass();
        HashSet classes = new HashSet();
        classes.add(javaClass);
        for (Class superclass = javaClass.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        String javaArchiveName = javaArchive.getName();
        if (!javaArchiveName.endsWith(".war")) {
            for (Class clazz : classes) {
                boolean testClassFound = false;
                String className = clazz.getName();
                String path = className.replace('.', '/') + ".class";
                Map javaArchiveContentMap = javaArchive.getContent();
                for (ArchivePath auxpath : javaArchiveContentMap.keySet()) {
                    if (!auxpath.toString().endsWith(path)) continue;
                    testClassFound = true;
                    break;
                }
                if (testClassFound) continue;
                javaArchive.addClass(clazz);
            }
        }
        ManifestManager manifestManager = (ManifestManager)this._manifestManagerInstance.get();
        Manifest manifest = manifestManager.putAttributeValue(manifestManager.getManifest(javaArchive), "Export-Package", javaClass.getPackage().getName());
        manifestManager.replaceManifest((Archive)javaArchive, manifest);
    }

    private void cleanRepeatedImports(JavaArchive javaArchive, Collection<Archive<?>> auxiliaryArchives) throws IOException {
        ImportPackageManager importPackageManager = (ImportPackageManager)this._importPackageManagerInstance.get();
        ManifestManager manifestManager = (ManifestManager)this._manifestManagerInstance.get();
        Manifest manifest = manifestManager.getManifest(javaArchive);
        manifest = importPackageManager.cleanRepeatedImports(manifest, auxiliaryArchives);
        manifestManager.replaceManifest((Archive)javaArchive, manifest);
    }

    private void handleAuxiliaryArchives(JavaArchive javaArchive, Collection<Archive<?>> auxiliaryArchives) throws IOException {
        for (Archive<?> auxiliaryArchive : auxiliaryArchives) {
            Map remoteLoadableExtensionMap = auxiliaryArchive.getContent(Filters.include((String)_REMOTE_LOADABLE_EXTENSION_FILE));
            Collection remoteLoadableExtensions = remoteLoadableExtensionMap.values();
            if (remoteLoadableExtensions.size() > 1) {
                throw new RuntimeException("The archive " + auxiliaryArchive.getName() + " contains more than one RemoteLoadableExtension file");
            }
            if (remoteLoadableExtensions.size() == 1) {
                Iterator remoteLoadableExtensionsIterator = remoteLoadableExtensions.iterator();
                Node remoteLoadableExtensionsNext = (Node)remoteLoadableExtensionsIterator.next();
                javaArchive.add(remoteLoadableExtensionsNext.getAsset(), _REMOTE_LOADABLE_EXTENSION_FILE);
            }
            ZipExporter auxiliaryArchiveZipExporter = (ZipExporter)auxiliaryArchive.as(ZipExporter.class);
            InputStream auxiliaryArchiveInputStream = auxiliaryArchiveZipExporter.exportAsInputStream();
            ByteArrayAsset byteArrayAsset = new ByteArrayAsset(auxiliaryArchiveInputStream);
            String path = "extension/" + auxiliaryArchive.getName();
            javaArchive.addAsResource((Asset)byteArrayAsset, path);
            ManifestManager manifestManager = (ManifestManager)this._manifestManagerInstance.get();
            Manifest manifest = manifestManager.putAttributeValue(manifestManager.getManifest(javaArchive), "Bundle-ClassPath", ".", path);
            manifestManager.replaceManifest((Archive)javaArchive, manifest);
            try {
                String bundleActivatorValue;
                this.validateBundleArchive(auxiliaryArchive);
                Manifest auxiliaryArchiveManifest = manifestManager.getManifest((JavaArchive)auxiliaryArchive);
                Attributes mainAttributes = auxiliaryArchiveManifest.getMainAttributes();
                String value = mainAttributes.getValue("Import-package");
                if (value != null) {
                    String[] importValues = value.split(",");
                    manifest = manifestManager.putAttributeValue(manifest, "Import-Package", importValues);
                    manifestManager.replaceManifest((Archive)javaArchive, manifest);
                }
                if ((bundleActivatorValue = mainAttributes.getValue("Bundle-Activator")) == null || bundleActivatorValue.isEmpty()) continue;
                this.addBundleActivator(javaArchive, bundleActivatorValue);
            }
            catch (BundleException e) {
                if (!_logger.isInfoEnabled()) continue;
                _logger.info("Not processing manifest from " + auxiliaryArchive + ": " + e.getMessage());
            }
        }
    }

    private List<Archive<?>> loadAuxiliaryArchives() {
        ArrayList archives = new ArrayList();
        ServiceLoader serviceLoader = (ServiceLoader)this._serviceLoaderInstance.get();
        Collection archiveAppenders = serviceLoader.all(AuxiliaryArchiveAppender.class);
        for (AuxiliaryArchiveAppender archiveAppender : archiveAppenders) {
            Archive auxiliaryArchive = archiveAppender.createAuxiliaryArchive();
            if (auxiliaryArchive == null) continue;
            archives.add(auxiliaryArchive);
        }
        return archives;
    }

    private void validateBundleArchive(Archive<?> archive) throws BundleException, IOException {
        Manifest manifest = null;
        Node node = archive.get("META-INF/MANIFEST.MF");
        if (node != null) {
            manifest = new Manifest(node.getAsset().openStream());
        }
        if (manifest == null) {
            throw new BundleException("can't obtain Manifest");
        }
        OSGiManifestBuilder.validateBundleManifest(manifest);
    }
}

