/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.restassured;

import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import java.util.Arrays;

public class AuthenticationSchemeFactory {
    public static AuthenticationScheme create(String attribute) {
        String[] parameters = attribute.split(":");
        if (parameters.length < 2) {
            throw new IllegalArgumentException(String.format("Authentication scheme %s doesn't follow the standard format <protocol>:(<value>[:])+", new Object[0]));
        }
        switch (parameters[0]) {
            case "basic": {
                AuthenticationSchemeFactory.validateEntry(parameters, 3);
                return RestAssured.basic((String)parameters[1], (String)parameters[2]);
            }
            case "form": {
                AuthenticationSchemeFactory.validateEntry(parameters, 3);
                return RestAssured.form((String)parameters[1], (String)parameters[2]);
            }
            case "preemptive": {
                AuthenticationSchemeFactory.validateEntry(parameters, 3);
                return RestAssured.preemptive().basic(parameters[1], parameters[2]);
            }
            case "certificate": {
                AuthenticationSchemeFactory.validateEntryBigger(parameters, 3);
                String[] url = Arrays.copyOfRange(parameters, 2, parameters.length - 1);
                return RestAssured.certificate((String)AuthenticationSchemeFactory.join(url), (String)parameters[parameters.length - 1]);
            }
            case "digest": {
                AuthenticationSchemeFactory.validateEntry(parameters, 3);
                return RestAssured.digest((String)parameters[1], (String)parameters[2]);
            }
            case "oauth": {
                AuthenticationSchemeFactory.validateEntry(parameters, 5);
                return RestAssured.oauth((String)parameters[1], (String)parameters[2], (String)parameters[3], (String)parameters[4]);
            }
            case "oauth2": {
                AuthenticationSchemeFactory.validateEntry(parameters, 2);
                return RestAssured.oauth2((String)parameters[1]);
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized protocol %s", parameters[0]));
    }

    private static String join(String[] elements) {
        StringBuilder builder = new StringBuilder();
        for (String s : elements) {
            builder.append(s);
        }
        return builder.toString();
    }

    private static void validateEntryBigger(String[] parameters, int numberOfValid) {
        if (parameters.length < numberOfValid) {
            throw new IllegalArgumentException(String.format("Invalid number of parameters for %s command.", Arrays.toString(parameters)));
        }
    }

    private static void validateEntry(String[] parameters, int numberOfValid) {
        if (parameters.length != numberOfValid) {
            throw new IllegalArgumentException(String.format("Invalid number of parameters for %s command.", Arrays.toString(parameters)));
        }
    }
}

