/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

import java.util.ArrayList;
import java.util.Collection;
import org.arquillian.cube.docker.impl.client.config.ExposedPort;

public class PortBinding {
    private String host;
    private int bound;
    private ExposedPort exposed;

    public PortBinding(String host, int bound, ExposedPort exposed) {
        this.host = host;
        this.bound = bound;
        this.exposed = exposed;
    }

    public PortBinding(String portBinding) {
        PortBinding parsed = PortBinding.valueOf(portBinding);
        this.host = parsed.host;
        this.bound = parsed.bound;
        this.exposed = parsed.exposed;
    }

    public static PortBinding valueOf(String portBinding) {
        int bound;
        ExposedPort exposed;
        String host = null;
        String[] elements = portBinding.split("->");
        if (elements.length == 1) {
            int positionOfProtocolSeparator = elements[0].indexOf("/");
            String bindingPortValue = elements[0];
            if (positionOfProtocolSeparator > -1) {
                bindingPortValue = elements[0].substring(0, positionOfProtocolSeparator);
            }
            exposed = ExposedPort.valueOf(elements[0]);
            bound = exposed.getExposed();
            if (bindingPortValue.indexOf(":") != -1) {
                host = bindingPortValue.substring(0, bindingPortValue.lastIndexOf(":"));
            }
        } else if (elements.length == 2) {
            exposed = ExposedPort.valueOf(elements[1]);
            if (elements[0].indexOf(":") != -1) {
                host = elements[0].substring(0, elements[0].lastIndexOf(":"));
                bound = Integer.parseInt(elements[0].substring(elements[0].lastIndexOf(":") + 1, elements[0].length()));
            } else {
                bound = Integer.parseInt(elements[0]);
            }
        } else {
            throw new IllegalArgumentException("Could not create PortBinding from " + portBinding);
        }
        return new PortBinding(host, bound, exposed);
    }

    public static Collection<PortBinding> valuesOf(Collection<String> bindings) {
        if (bindings == null) {
            return null;
        }
        ArrayList<PortBinding> result = new ArrayList<PortBinding>();
        for (String binding : bindings) {
            result.add(PortBinding.valueOf(binding));
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getBound() {
        return this.bound;
    }

    public void setBound(int bound) {
        this.bound = bound;
    }

    public ExposedPort getExposedPort() {
        return this.exposed;
    }

    public void setExposedPort(ExposedPort exposed) {
        this.exposed = exposed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bound;
        result = 31 * result + (this.exposed == null ? 0 : this.exposed.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortBinding other = (PortBinding)obj;
        if (this.bound != other.bound) {
            return false;
        }
        if (this.exposed == null ? other.exposed != null : !this.exposed.equals(other.exposed)) {
            return false;
        }
        return !(this.host == null ? other.host != null : !this.host.equals(other.host));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.host != null) {
            sb.append(this.host).append(":");
        }
        if (this.exposed.getExposed() != this.bound) {
            sb.append(this.bound).append("->");
        }
        sb.append(this.exposed.getExposed()).append("/").append(this.exposed.getType());
        return sb.toString();
    }
}

