/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.ArrayList;
import java.util.List;
import org.arquillian.cube.docker.impl.client.AutomaticResolutionLinksAutoStartParser;
import org.arquillian.cube.docker.impl.client.AutomaticResolutionNetworkAutoStartParser;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.impl.util.ContainerUtil;
import org.arquillian.cube.spi.AutoStartParser;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CubeDockerAutoStartConfigurator {
    private static List<String> toContainersName(List<Container> containers) {
        ArrayList<String> containerNames = new ArrayList<String>();
        for (Container container : containers) {
            containerNames.add(ContainerUtil.getCubeIDForContainer((Container)container));
        }
        return containerNames;
    }

    public void configure(@Observes CubeDockerConfiguration event, ArquillianDescriptor arquillianDescriptor, ContainerRegistry registry) {
        if (event.getAutoStartContainers() == null) {
            AutoStartParser autoStartParser = this.resolveNotSetAutoStart(registry, event.getDockerContainersContent());
            event.setAutoStartContainers(autoStartParser);
        }
    }

    private AutoStartParser resolveNotSetAutoStart(ContainerRegistry containerRegistry, DockerCompositions containers) {
        List<String> containersName = CubeDockerAutoStartConfigurator.toContainersName(containerRegistry.getContainers());
        if (containers.getNetworkIds().size() > 0) {
            return new AutomaticResolutionNetworkAutoStartParser(containersName, containers);
        }
        return new AutomaticResolutionLinksAutoStartParser(containersName, containers);
    }
}

