/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.drone;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Logger;
import org.arquillian.cube.docker.drone.CubeDroneConfiguration;
import org.arquillian.cube.docker.drone.util.SeleniumVersionExtractor;
import org.arquillian.cube.docker.drone.util.VideoFileDestination;
import org.arquillian.cube.docker.drone.util.VolumeCreator;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.BuildImage;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.Image;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.client.config.StarOperator;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemResolver;

public class SeleniumContainers {
    private static final Logger logger = Logger.getLogger(SeleniumContainers.class.getName());
    private static final String SELENIUM_CONTAINER_BASE_NAME = "browser";
    private static final String VNC_CONTAINER_BASE_NAME = "vnc";
    private static final String CONVERSION_CONTAINER_BASE_NAME = "flv2mp4";
    private static final String CHROME_IMAGE = "selenium/standalone-chrome-debug:%s";
    private static final String FIREFOX_IMAGE = "selenium/standalone-firefox-debug:%s";
    private static final String VNC_IMAGE = "richnorth/vnc-recorder:latest";
    private static final String CONVERSION_IMAGE = "arquillian/flv2mp4:0.0.1";
    private static final String DEFAULT_PASSWORD = "secret";
    private static final String VNC_HOSTNAME = "vnchost";
    private static final String VOLUME_DIR = "/recording";
    private static final int VNC_EXPOSED_PORT = 5900;
    public static final String[] FLVREC_COMMAND = new String[]{"-o", "/recording/screen.flv", "-P", "/recording/password", "vnchost", Integer.toString(5900)};
    private CubeContainer seleniumContainer;
    private CubeContainer vncContainer;
    private CubeContainer videoConverterContainer;
    private String browser;
    private Path videoRecordingFolder;
    private final String seleniumContainerName;
    private final String vncContainerName;
    private final String conversionContainerName;
    private final int seleniumBoundedPort;

    private SeleniumContainers(String browser, CubeDroneConfiguration cubeDroneConfiguration) {
        this.browser = browser;
        switch (cubeDroneConfiguration.getContainerNameStrategy()) {
            case RANDOM: {
                UUID uuid = UUID.randomUUID();
                this.seleniumContainerName = StarOperator.generateNewName((String)SELENIUM_CONTAINER_BASE_NAME, (UUID)uuid);
                this.vncContainerName = StarOperator.generateNewName((String)VNC_CONTAINER_BASE_NAME, (UUID)uuid);
                this.conversionContainerName = StarOperator.generateNewName((String)CONVERSION_CONTAINER_BASE_NAME, (UUID)uuid);
                this.seleniumBoundedPort = StarOperator.generateRandomPrivatePort();
                break;
            }
            case STATIC_PREFIX: {
                this.seleniumContainerName = cubeDroneConfiguration.getContainerNamePrefix() + "_" + SELENIUM_CONTAINER_BASE_NAME;
                this.vncContainerName = cubeDroneConfiguration.getContainerNamePrefix() + "_" + VNC_CONTAINER_BASE_NAME;
                this.conversionContainerName = cubeDroneConfiguration.getContainerNamePrefix() + "_" + CONVERSION_CONTAINER_BASE_NAME;
                this.seleniumBoundedPort = StarOperator.generateRandomPrivatePort();
                break;
            }
            default: {
                this.seleniumContainerName = SELENIUM_CONTAINER_BASE_NAME;
                this.vncContainerName = VNC_CONTAINER_BASE_NAME;
                this.conversionContainerName = CONVERSION_CONTAINER_BASE_NAME;
                this.seleniumBoundedPort = 14444;
            }
        }
        this.videoRecordingFolder = VolumeCreator.createTemporaryVolume(DEFAULT_PASSWORD);
        this.seleniumContainer = SeleniumContainers.createSeleniumContainer(browser, cubeDroneConfiguration, this.seleniumBoundedPort);
        this.vncContainer = SeleniumContainers.createVncContainer(this.videoRecordingFolder, this.seleniumContainerName);
        Path targetVolume = VideoFileDestination.resolveTargetDirectory(cubeDroneConfiguration);
        this.videoConverterContainer = SeleniumContainers.createVideoConverterContainer(targetVolume);
    }

    public static SeleniumContainers create(String browser, CubeDroneConfiguration cubeDroneConfiguration) {
        return new SeleniumContainers(browser, cubeDroneConfiguration);
    }

    private static CubeContainer createVideoConverterContainer(Path dockerVolume) {
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setImage(Image.valueOf((String)CONVERSION_IMAGE));
        cubeContainer.setBinds(Arrays.asList(SeleniumContainers.convertToBind(dockerVolume, VOLUME_DIR, "Z")));
        Await await = new Await();
        await.setStrategy("log");
        await.setMatch("CONVERSION COMPLETED");
        cubeContainer.setAwait(await);
        cubeContainer.setManual(true);
        return cubeContainer;
    }

    private static CubeContainer createVncContainer(Path dockerVolume, String seleniumContainerName) {
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setImage(Image.valueOf((String)VNC_IMAGE));
        cubeContainer.setBinds(Arrays.asList(SeleniumContainers.convertToBind(dockerVolume, VOLUME_DIR, "Z")));
        Link link = Link.valueOf((String)(seleniumContainerName + ":" + VNC_HOSTNAME));
        cubeContainer.setLinks(Arrays.asList(link));
        Await await = new Await();
        await.setStrategy("sleeping");
        await.setSleepTime((Object)"100 ms");
        cubeContainer.setAwait(await);
        cubeContainer.setCmd(Arrays.asList(FLVREC_COMMAND));
        cubeContainer.setManual(true);
        return cubeContainer;
    }

    private static String convertToBind(Path hostPath, String containterPath, String mode) {
        boolean isWindows = new OperatingSystemResolver().currentOperatingSystem().getFamily() == OperatingSystemFamily.WINDOWS;
        Path absoluteHostPath = hostPath.toAbsolutePath();
        if (isWindows) {
            StringBuilder convertedHostPath = new StringBuilder();
            String hostRoot = absoluteHostPath.getRoot().toString();
            if (hostRoot.matches("[a-zA-Z]:\\\\")) {
                convertedHostPath.append('/');
                convertedHostPath.append(hostRoot.toLowerCase().charAt(0));
            } else {
                convertedHostPath.append(hostRoot.replace("\\\\", "/").replace("\\", "/"));
                if (convertedHostPath.charAt(convertedHostPath.length() - 1) == '/') {
                    convertedHostPath.deleteCharAt(convertedHostPath.length() - 1);
                }
            }
            for (Path pathElem : absoluteHostPath) {
                convertedHostPath.append('/');
                convertedHostPath.append(pathElem.toString());
            }
            if (!absoluteHostPath.startsWith("C:\\Users")) {
                logger.warning(String.format("You're not running below the default shared path 'C:\\Users'. Make sure you have set up a shared folder making the host path '%s' accessible as '%s' in your Docker virtual machine.", absoluteHostPath, convertedHostPath));
            }
            return convertedHostPath + ":" + containterPath + ":" + mode;
        }
        return absoluteHostPath + ":" + containterPath + ":" + mode;
    }

    private static CubeContainer createSeleniumContainer(String browser, CubeDroneConfiguration cubeDroneConfiguration, int seleniumBoundedPort) {
        if (cubeDroneConfiguration.isBrowserDockerfileDirectorySet()) {
            return SeleniumContainers.createCube(cubeDroneConfiguration.getBrowserDockerfileLocation(), seleniumBoundedPort);
        }
        if (cubeDroneConfiguration.isBrowserImageSet()) {
            return SeleniumContainers.configureCube(cubeDroneConfiguration.getBrowserImage(), seleniumBoundedPort);
        }
        return SeleniumContainers.useOfficialSeleniumImages(browser, seleniumBoundedPort);
    }

    private static CubeContainer useOfficialSeleniumImages(String browser, int seleniumBoundedPort) {
        String version = SeleniumVersionExtractor.fromClassPath();
        switch (browser) {
            case "firefox": {
                return SeleniumContainers.configureCube(String.format(FIREFOX_IMAGE, version), seleniumBoundedPort);
            }
            case "chrome": {
                return SeleniumContainers.configureCube(String.format(CHROME_IMAGE, version), seleniumBoundedPort);
            }
        }
        throw new UnsupportedOperationException("Unsupported browser " + browser + ". Only firefox and chrome are supported.");
    }

    private static CubeContainer createCube(String dockerFileLocation, int seleniumBoundedPort) {
        CubeContainer cubeContainer = new CubeContainer();
        BuildImage buildImage = new BuildImage(dockerFileLocation, null, true, true);
        cubeContainer.setBuildImage(buildImage);
        SeleniumContainers.setDefaultSeleniumCubeProperties(cubeContainer, seleniumBoundedPort);
        return cubeContainer;
    }

    private static CubeContainer configureCube(String image, int seleniumBoundedPort) {
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setImage(Image.valueOf((String)image));
        SeleniumContainers.setDefaultSeleniumCubeProperties(cubeContainer, seleniumBoundedPort);
        return cubeContainer;
    }

    private static void setDefaultSeleniumCubeProperties(CubeContainer cubeContainer, int seleniumBoundedPort) {
        cubeContainer.setPortBindings(Arrays.asList(PortBinding.valueOf((String)(seleniumBoundedPort + "-> 4444"))));
        Await await = new Await();
        await.setStrategy("http");
        await.setResponseCode(Integer.valueOf(SeleniumContainers.getSeleniumExpectedResponseCode()));
        await.setUrl("http://dockerHost:" + seleniumBoundedPort);
        cubeContainer.setAwait(await);
        cubeContainer.setKillContainer(true);
    }

    private static int getSeleniumExpectedResponseCode() {
        int seleniumMajorVersion;
        int expectedResponseCode = 200;
        String seleniumVersion = SeleniumVersionExtractor.fromClassPath();
        if (seleniumVersion.matches("[0-9]+\\.?.*") && (seleniumMajorVersion = Integer.parseInt(seleniumVersion.substring(0, seleniumVersion.indexOf(46)))) < 3) {
            expectedResponseCode = 403;
        }
        return expectedResponseCode;
    }

    public CubeContainer getSeleniumContainer() {
        return this.seleniumContainer;
    }

    public CubeContainer getVncContainer() {
        return this.vncContainer;
    }

    public CubeContainer getVideoConverterContainer() {
        return this.videoConverterContainer;
    }

    public Path getVideoRecordingFolder() {
        return this.videoRecordingFolder;
    }

    public Path getVideoRecordingFile() {
        return this.videoRecordingFolder.resolve("screen.flv");
    }

    public int getSeleniumBoundedPort() {
        return this.seleniumBoundedPort;
    }

    public String getSeleniumContainerName() {
        return this.seleniumContainerName;
    }

    public String getVncContainerName() {
        return this.vncContainerName;
    }

    public String getVideoConverterContainerName() {
        return this.conversionContainerName;
    }

    public String getBrowser() {
        return this.browser;
    }
}

