/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.drone.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public class VolumeCreator {
    private VolumeCreator() {
    }

    public static final Path createTemporaryVolume(String password) {
        final File tmpFile = new File(".tmp" + System.currentTimeMillis());
        if (!tmpFile.mkdirs()) {
            throw new IllegalArgumentException("Temporary Folder for storing recordings could not be created.");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FileUtils.deleteQuietly((File)tmpFile);
            }
        });
        Path temp = tmpFile.toPath();
        Path passwordFile = temp.resolve("password");
        try {
            Files.write(passwordFile, password.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return temp;
    }
}

