/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.drone;

import java.nio.file.Path;
import java.util.Arrays;
import org.arquillian.cube.docker.drone.CubeDroneConfiguration;
import org.arquillian.cube.docker.drone.util.SeleniumVersionExtractor;
import org.arquillian.cube.docker.drone.util.VideoFileDestination;
import org.arquillian.cube.docker.drone.util.VolumeCreator;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.BuildImage;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.Image;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;

public class SeleniumContainers {
    private static final String CHROME_IMAGE = "selenium/standalone-chrome-debug:%s";
    private static final String FIREFOX_IMAGE = "selenium/standalone-firefox-debug:%s";
    private static final String VNC_IMAGE = "richnorth/vnc-recorder:latest";
    private static final String CONVERSION_IMAGE = "arquillian/flv2mp4:0.0.1";
    private static final String DEFAULT_PASSWORD = "secret";
    private static final String VNC_HOSTNAME = "vnchost";
    private static final String VOLUME_DIR = "recording";
    private static final int SELENIUM_BOUNDED_PORT = 14444;
    private static final int VNC_EXPOSED_PORT = 5900;
    public static final String SELENIUM_CONTAINER_NAME = "browser";
    public static final String VNC_CONTAINER_NAME = "vnc";
    public static final String CONVERSION_CONTAINER_NAME = "flv2mp4";
    public static final String[] FLVREC_COMMAND = new String[]{"-o", "/recording/screen.flv", "-P", "/recording/password", "vnchost", Integer.toString(5900)};
    private CubeContainer seleniumContainer;
    private CubeContainer vncContainer;
    private CubeContainer videoConverterContainer;
    private String browser;
    private Path videoRecordingFolder;

    private SeleniumContainers(CubeContainer seleniumContainer, String browser, CubeContainer vncContainer, CubeContainer videoConverterContainer, Path videoRecordingFolder) {
        this.seleniumContainer = seleniumContainer;
        this.vncContainer = vncContainer;
        this.videoConverterContainer = videoConverterContainer;
        this.browser = browser;
        this.videoRecordingFolder = videoRecordingFolder;
    }

    public CubeContainer getSeleniumContainer() {
        return this.seleniumContainer;
    }

    public CubeContainer getVncContainer() {
        return this.vncContainer;
    }

    public CubeContainer getVideoConverterContainer() {
        return this.videoConverterContainer;
    }

    public Path getVideoRecordingFolder() {
        return this.videoRecordingFolder;
    }

    public Path getVideoRecordingFile() {
        return this.videoRecordingFolder.resolve("screen.flv");
    }

    public int getSeleniumBoundedPort() {
        return 14444;
    }

    public String getSeleniumContainerName() {
        return SELENIUM_CONTAINER_NAME;
    }

    public String getVncContainerName() {
        return VNC_CONTAINER_NAME;
    }

    public String getVideoConverterContainerName() {
        return CONVERSION_CONTAINER_NAME;
    }

    public String getBrowser() {
        return this.browser;
    }

    public static SeleniumContainers create(String browser, CubeDroneConfiguration cubeDroneConfiguration) {
        Path temporaryVolume = VolumeCreator.createTemporaryVolume(DEFAULT_PASSWORD);
        Path targetVolume = VideoFileDestination.resolveTargetDirectory(cubeDroneConfiguration);
        return new SeleniumContainers(SeleniumContainers.createSeleniumContainer(browser, cubeDroneConfiguration), browser, SeleniumContainers.createVncContainer(temporaryVolume), SeleniumContainers.createVideoConverterContainer(targetVolume), temporaryVolume);
    }

    private static CubeContainer createVideoConverterContainer(Path dockerVolume) {
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setImage(Image.valueOf((String)CONVERSION_IMAGE));
        cubeContainer.setBinds(Arrays.asList(dockerVolume.toAbsolutePath().toString() + ":/" + VOLUME_DIR + ":rw"));
        Await await = new Await();
        await.setStrategy("log");
        await.setMatch("CONVERSION COMPLETED");
        cubeContainer.setAwait(await);
        cubeContainer.setManual(true);
        return cubeContainer;
    }

    private static CubeContainer createVncContainer(Path dockerVolume) {
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setImage(Image.valueOf((String)VNC_IMAGE));
        cubeContainer.setBinds(Arrays.asList(dockerVolume.toAbsolutePath().toString() + ":/" + VOLUME_DIR + ":rw"));
        Link link = Link.valueOf((String)"browser:vnchost");
        cubeContainer.setLinks(Arrays.asList(link));
        Await await = new Await();
        await.setStrategy("sleeping");
        await.setSleepTime((Object)"100 ms");
        cubeContainer.setAwait(await);
        cubeContainer.setCmd(Arrays.asList(FLVREC_COMMAND));
        cubeContainer.setManual(true);
        return cubeContainer;
    }

    private static CubeContainer createSeleniumContainer(String browser, CubeDroneConfiguration cubeDroneConfiguration) {
        if (cubeDroneConfiguration.isBrowserDockerfileDirectorySet()) {
            return SeleniumContainers.createCube(cubeDroneConfiguration.getBrowserDockerfileLocation());
        }
        if (cubeDroneConfiguration.isBrowserImageSet()) {
            return SeleniumContainers.configureCube(cubeDroneConfiguration.getBrowserImage());
        }
        return SeleniumContainers.useOfficialSeleniumImages(browser);
    }

    private static CubeContainer useOfficialSeleniumImages(String browser) {
        String version = SeleniumVersionExtractor.fromClassPath();
        switch (browser) {
            case "firefox": {
                return SeleniumContainers.configureCube(String.format(FIREFOX_IMAGE, version));
            }
            case "chrome": {
                return SeleniumContainers.configureCube(String.format(CHROME_IMAGE, version));
            }
        }
        throw new UnsupportedOperationException("Unsupported browser " + browser + ". Only firefox and chrome are supported.");
    }

    private static CubeContainer createCube(String dockerFileLocation) {
        CubeContainer cubeContainer = new CubeContainer();
        BuildImage buildImage = new BuildImage(dockerFileLocation, null, true, true);
        cubeContainer.setBuildImage(buildImage);
        SeleniumContainers.setDefaultSeleniumCubeProperties(cubeContainer);
        return cubeContainer;
    }

    private static CubeContainer configureCube(String image) {
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setImage(Image.valueOf((String)image));
        SeleniumContainers.setDefaultSeleniumCubeProperties(cubeContainer);
        return cubeContainer;
    }

    private static void setDefaultSeleniumCubeProperties(CubeContainer cubeContainer) {
        cubeContainer.setPortBindings(Arrays.asList(PortBinding.valueOf((String)"14444-> 4444")));
        Await await = new Await();
        await.setStrategy("http");
        await.setResponseCode(Integer.valueOf(403));
        await.setUrl("http://dockerHost:14444");
        cubeContainer.setAwait(await);
        cubeContainer.setKillContainer(true);
    }
}

