/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.cube.docker.drone.SeleniumContainers;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DockerRemoteWebDriverFactory
extends AbstractWebDriverFactory<RemoteWebDriver>
implements Configurator<RemoteWebDriver, WebDriverConfiguration>,
Instantiator<RemoteWebDriver, WebDriverConfiguration>,
Destructor<RemoteWebDriver> {
    private static final Logger log = Logger.getLogger(DockerRemoteWebDriverFactory.class.getName());
    @Inject
    Instance<CubeDockerConfiguration> cubeDockerConfigurationInstance;
    @Inject
    Instance<SeleniumContainers> seleniumContainersInstance;

    public void destroyInstance(RemoteWebDriver remoteWebDriver) {
        try {
            remoteWebDriver.quit();
        }
        catch (WebDriverException e) {
            log.log(Level.WARNING, "@Drone {0} has been already destroyed and can't be destroyed again.", remoteWebDriver.getClass().getSimpleName());
        }
    }

    public RemoteWebDriver createInstance(WebDriverConfiguration webDriverConfiguration) {
        RemoteWebDriver remoteWebDriver = new RemoteWebDriver(this.createSeleniumUrl(), (Capabilities)this.getDesiredCapabilities());
        return remoteWebDriver;
    }

    private DesiredCapabilities getDesiredCapabilities() {
        SeleniumContainers seleniumContainers = (SeleniumContainers)this.seleniumContainersInstance.get();
        switch (seleniumContainers.getBrowser()) {
            case "firefox": {
                return DesiredCapabilities.firefox();
            }
            case "chrome": {
                return DesiredCapabilities.chrome();
            }
        }
        return DesiredCapabilities.firefox();
    }

    private URL createSeleniumUrl() {
        try {
            CubeDockerConfiguration cubeDockerConfiguration = (CubeDockerConfiguration)this.cubeDockerConfigurationInstance.get();
            SeleniumContainers seleniumContainers = (SeleniumContainers)this.seleniumContainersInstance.get();
            String dockerServerIp = cubeDockerConfiguration.getDockerServerIp();
            return new URL("http", dockerServerIp, seleniumContainers.getSeleniumBoundedPort(), "/wd/hub");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String getDriverReadableName() {
        return "Docker Remote Web Driver";
    }

    public int getPrecedence() {
        return Integer.MAX_VALUE;
    }
}

