/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.drone.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.arquillian.cube.docker.drone.CubeDroneConfiguration;
import org.jboss.arquillian.test.spi.event.suite.After;

public class VideoFileDestination {
    private static final File DEFAULT_LOCATION_OUTPUT_MAVEN = new File("target");
    private static final File DEFAULT_LOCATION_OUTPUT_GRADLE = new File("build");

    private VideoFileDestination() {
    }

    public static Path getFinalLocation(After afterTestMethod, CubeDroneConfiguration cubeDroneConfiguration) {
        return VideoFileDestination.resolveTargetDirectory(cubeDroneConfiguration).resolve(VideoFileDestination.getFinalVideoName(afterTestMethod));
    }

    private static Path resolveTargetDirectory(CubeDroneConfiguration cubeDroneConfiguration) {
        Path output;
        if (cubeDroneConfiguration.isVideoOutputDirectorySet()) {
            output = Paths.get(cubeDroneConfiguration.getFinalDirectory(), new String[0]);
        } else if (DEFAULT_LOCATION_OUTPUT_GRADLE.exists()) {
            output = DEFAULT_LOCATION_OUTPUT_GRADLE.toPath().resolve("reports").resolve("videos");
        } else if (DEFAULT_LOCATION_OUTPUT_MAVEN.exists()) {
            output = DEFAULT_LOCATION_OUTPUT_MAVEN.toPath().resolve("reports").resolve("videos");
        } else {
            if (!DEFAULT_LOCATION_OUTPUT_MAVEN.mkdirs()) {
                throw new IllegalArgumentException("Couldn't create directory for storing videos");
            }
            output = DEFAULT_LOCATION_OUTPUT_MAVEN.toPath().resolve("reports").resolve("videos");
        }
        try {
            Files.createDirectories(output, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't create directory for storing videos");
        }
        return output;
    }

    private static String getFinalVideoName(After afterTestMethod) {
        String className = afterTestMethod.getTestClass().getName().replace('.', '_');
        String methodName = afterTestMethod.getTestMethod().getName();
        return className + "_" + methodName + ".flv";
    }
}

