/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.deployment.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import org.arquillian.container.chameleon.deployment.api.AbstractAutomaticDeployment;
import org.arquillian.container.chameleon.deployment.maven.MavenBuild;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuiltProject;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.EmbeddedMaven;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.pom.equipped.ConfigurationDistributionStage;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.pom.equipped.PomEquippedEmbeddedMaven;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.BuiltProjectImpl;

public class MavenBuildAutomaticDeployment
extends AbstractAutomaticDeployment {
    protected Archive<?> build(TestClass testClass) {
        if (testClass.isAnnotationPresent(MavenBuild.class)) {
            MavenBuild mavenBuildDeployment = (MavenBuild)testClass.getAnnotation(MavenBuild.class);
            return this.runBuild(mavenBuildDeployment);
        }
        return null;
    }

    private Archive<?> runBuild(MavenBuild conf) {
        Object[] properties;
        ConfigurationDistributionStage configurationDistributionStage = this.getConfigurationDistributionStage(conf);
        configurationDistributionStage.setQuiet(conf.quiet());
        if (this.isNotEmptyOrNull(conf.localRepositoryDirectory())) {
            configurationDistributionStage.setLocalRepositoryDirectory(new File(conf.localRepositoryDirectory()));
        }
        if (this.isNotEmptyOrNull(conf.mvnOpts())) {
            configurationDistributionStage.setMavenOpts(conf.mvnOpts());
        }
        if ((properties = conf.properties()).length % 2 != 0) {
            throw new IllegalArgumentException(String.format("Maven properties must be set in an array of pairs key, value, but in %s properties are odd", Arrays.toString(properties)));
        }
        for (int i = 0; i < properties.length; i += 2) {
            configurationDistributionStage.addProperty((String)properties[i], (String)properties[i + 1]);
        }
        BuiltProject build = configurationDistributionStage.ignoreFailure().build();
        if (this.isModuleSet(conf)) {
            File projectDirectory = build.getModel().getProjectDirectory();
            Path normalize = projectDirectory.toPath().normalize();
            String relativeModuleDirectory = conf.module().replace('/', File.separatorChar);
            build = this.getSubmodule(build, normalize.toString() + File.separator + relativeModuleDirectory + File.separator + "pom.xml");
        }
        return build.getDefaultBuiltArchive();
    }

    ConfigurationDistributionStage getConfigurationDistributionStage(MavenBuild conf) {
        PomEquippedEmbeddedMaven configurationDistributionStage = EmbeddedMaven.forProject((String)conf.pom());
        if (conf.useLocalInstallation()) {
            configurationDistributionStage.useLocalInstallation();
        } else {
            configurationDistributionStage.useMaven3Version(conf.version());
        }
        return (ConfigurationDistributionStage)((ConfigurationDistributionStage)((ConfigurationDistributionStage)((ConfigurationDistributionStage)configurationDistributionStage.setGoals(conf.goals())).setProfiles(conf.profiles())).setOffline(conf.offline())).skipTests(true);
    }

    private boolean isModuleSet(MavenBuild conf) {
        return !"".equals(conf.module());
    }

    private BuiltProject getSubmodule(BuiltProject builtProject, String pomfile) {
        BuiltProjectImpl submodule = new BuiltProjectImpl(pomfile, new String[0]);
        submodule.setMavenBuildExitCode(builtProject.getMavenBuildExitCode());
        submodule.setMavenLog(builtProject.getMavenLog());
        return submodule;
    }

    private boolean isNotEmptyOrNull(String value) {
        return value != null && value.length() > 0;
    }
}

